package com.crawler.weixin.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(Include.NON_EMPTY)
public class Menu {
	
	public static String TYPE_VIEW = "view"; // 链接
	public static String TYPE_CLICK = "click"; // 点击事件
	public static String TYPE_MINIPROGRAM = "miniprogram"; // 小程序
	
	public Menu() {}
	
	public Menu(String name) {
		this.name = name;
	}
	
	/**
	 * 生成链接菜单	
	 * @param name
	 * @param url
	 */
	public Menu(String name, String url) {
		this.name = name;
		this.type = TYPE_VIEW;
		this.url = url;
	}
	
	public Menu(Menu ... menus) {
		if(menus.length > 0) {
			this.button = Arrays.asList(menus);
		}
	}
	
	/**
	 * 生成小程序按钮
	 * @param name
	 * @param appid
	 * @param pagepath
	 */
	public Menu(String name, String appid, String pagepath) {
		this.name = name;
		this.type = TYPE_MINIPROGRAM;
		this.appid = appid;
		this.pagepath = pagepath;
		this.url = "http://mp.weixin.qq.com";
	}
	
	/**
	 * 一级菜单数组，个数应为1~3个
	 */
	private List<Menu> button;

	/**
	 * 菜单标题
	 */
	private String name;
	
	/**
	 * 菜单的响应动作类型，view表示网页类型，click表示点击类型，miniprogram表示小程序类型
	 */
	private String type;
	
	/**
	 * 菜单KEY值，用于消息接口推送，不超过128字节(click等点击类型必须	)
	 */
	private String key;
	
	/**
	 * 网页 链接，用户点击菜单可打开链接，不超过1024字节。 type为miniprogram时，不支持小程序的老版本客户端将打开本url。
	 * (view、miniprogram类型必须)
	 */
	private String url;
	
	/**
	 * 调用新增永久素材接口返回的合法media_id
	 */
	@JsonProperty("media_id")
	private String mediaId;
	
	/**
	 * 小程序的appid
	 */
	private String appid;
	
	/**
	 * 小程序的页面路径
	 */
	private String pagepath;
	
	/**
	 *  二级菜单数组，个数应为1~5个
	 */
	@JsonProperty("sub_button")
	private List<Menu> subButton;

	public List<Menu> getButton() {
		return button;
	}

	public void setButton(List<Menu> button) {
		this.button = button;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getPagepath() {
		return pagepath;
	}

	public void setPagepath(String pagepath) {
		this.pagepath = pagepath;
	}

	public List<Menu> getSubButton() {
		return subButton;
	}

	public void setSubButton(List<Menu> subButton) {
		this.subButton = subButton;
	}
	
	/**
	 * 添加子菜单
	 * @param subMenu
	 */
	public void addSubMenu(Menu subMenu) {
		if(this.subButton == null) {
			this.subButton = new ArrayList<Menu>();
		}
		this.subButton.add(subMenu);
	}
}
