package com.crawler.weixin.push;

import java.util.Map;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * 小程序消息模板
 * @author rubekid
 *
 * 2018年3月23日 下午1:43:43
 */
public class WeappTemplate {

	/**
	 * 用户OPENID
	 */
	private String touser;
	
	/**
	 * 模板ID
	 */
	@JSONField(name = "template_id")
	private String templateId;
	
	/**
	 * 小程序页面
	 */
	private String page;
	
	/**
	 * 表单ID
	 */
	@JSONField(name = "form_id")
	private String formId = "";
	
	/**
	 * 颜色
	 */
	private String color = "#000000";

	/**
	 * 数据
	 */
	private Map<String, TemplateParam> data;
	
	/**
	 * 模板需要放大的关键词
	 */
	@JSONField(name = "emphasis_keyword")
	private String emphasisKeyword = "";

	public String getTouser() {
		return touser;
	}

	public void setTouser(String touser) {
		this.touser = touser;
	}

	public String getTemplateId() {
		return templateId;
	}

	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public String getPage() {
		return page;
	}

	public void setPage(String page) {
		this.page = page;
	}

	public String getFormId() {
		return formId;
	}

	public void setFormId(String formId) {
		this.formId = formId;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

	public Map<String, TemplateParam> getData() {
		return data;
	}

	public void setData(Map<String, TemplateParam> data) {
		this.data = data;
	}

	public String getEmphasisKeyword() {
		return emphasisKeyword;
	}

	public void setEmphasisKeyword(String emphasisKeyword) {
		this.emphasisKeyword = emphasisKeyword;
	}
	
	
}
