package com.crawler.weixin.push;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crawler.social.config.SocialProperties;



/**
 * 小程序模板推送
 * @author Rubekid
 *
 * 2017年3月31日 下午8:26:15
 */
public class WeappTemplatePusher {

	private static final Logger LOGGER = LoggerFactory.getLogger(WeappTemplatePusher.class);
	


	 /**
    * 消息线程线程池大小
    */
   public static final int MESSAGE_POOL_SIZE = SocialProperties.getPropertyForInteger("template.thread.num", "10");
   
   /**
    * 线程池
    */
   private static ThreadPoolExecutor threadPool = (ThreadPoolExecutor) Executors.newFixedThreadPool(MESSAGE_POOL_SIZE);
	

	/**
	 * 发送消息
	 * @param template
	 * @param appId
	 * @param appSecret
	 */
	public static void send(WeappTemplate template, String appId, String appSecret){
		threadPool.execute(new WeappNotifyTask(appId, appSecret, template));
	}
}
