package com.crawler.weixin.vo;

import java.util.List;

public class FansUserInfo {
	
	/**
	 * 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。
	 */
	private Integer subscribe;
	
	/**
	 * 	用户的唯一标识
	 */
	private String openid;
	
	/**
	 * 	用户昵称
	 */
	private String nickname;
	
	/**
	 * 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
	 */
	private int sex;
	
	/**
	 * 用户个人资料填写的省份
	 */
	private String province;
	
	/**
	 * 	普通用户个人资料填写的城市
	 */
	private String city;
	
	/**
	 * 国家，如中国为CN
	 */
	private String country;	
	
	/**
	 * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。若用户更换头像，原有头像URL将失效。
	 */
	private String headimgurl;
	
	/**
	 * 用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间
	 */
	private Long subscribeTime;
	
	/**
	 * 只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。
	 */
	private String unionid;
	
	/**
	 * 公众号运营者对粉丝的备注，公众号运营者可在微信公众平台用户管理界面对粉丝添加备注
	 */
	private String remark;
	
	/**
	 * 用户所在的分组ID
	 */
	private String groupid;

	public Integer getSubscribe() {
		return subscribe;
	}

	public String getOpenid() {
		return openid;
	}

	public String getNickname() {
		return nickname;
	}

	public int getSex() {
		return sex;
	}

	public String getProvince() {
		return province;
	}

	public String getCity() {
		return city;
	}

	public String getCountry() {
		return country;
	}

	public String getHeadimgurl() {
		return headimgurl;
	}

	public Long getSubscribeTime() {
		return subscribeTime;
	}

	public String getUnionid() {
		return unionid;
	}

	public String getRemark() {
		return remark;
	}

	public String getGroupid() {
		return groupid;
	}

	public void setSubscribe(Integer subscribe) {
		this.subscribe = subscribe;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	public void setSex(int sex) {
		this.sex = sex;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public void setHeadimgurl(String headimgurl) {
		this.headimgurl = headimgurl;
	}

	public void setSubscribeTime(Long subscribeTime) {
		this.subscribeTime = subscribeTime;
	}

	public void setUnionid(String unionid) {
		this.unionid = unionid;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public void setGroupid(String groupid) {
		this.groupid = groupid;
	}
	

}
