/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.beans.Node;
import com.crawler.beans.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeNodeUtils {
    public static List<TreeNode> generateTree(List<Node> nodes, String rootId) {
        HashMap<String, List<TreeNode>> map = new HashMap<String, List<TreeNode>>();
        for (Node node : nodes) {
            String parentId = node.getParentId();
            List<TreeNode> treeNodes = new ArrayList();
            if (map.containsKey(parentId)) {
                treeNodes = (List)map.get(parentId);
            }
            TreeNode treeNode = new TreeNode();
            treeNode.setId(node.getId());
            treeNode.setName(node.getName());
            treeNode.setImage(node.getImage());
            treeNodes.add(treeNode);
            map.put(parentId, treeNodes);
        }
        return TreeNodeUtils.buildNode(map, rootId);
    }

    public static List<TreeNode> buildNode(Map<String, List<TreeNode>> map, String parentId) {
        List<TreeNode> nodes = map.get(parentId);
        if (nodes != null) {
            for (TreeNode treeNode : nodes) {
                treeNode.setChildren(TreeNodeUtils.buildNode(map, treeNode.getId()));
            }
        }
        return nodes;
    }
}

