/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.component.SpringContextUtil;
import com.crawler.rest.exceptions.extendExceptions.RestSimpleException;
import com.crawler.rest.security.authens.BaseUserInfo;
import com.crawler.rest.security.authens.UcUserToken;
import com.crawler.rest.support.RestContext;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.http.HttpStatus;

public class UcUtils {
    private static EhCacheCacheManager cacheManager = SpringContextUtil.getBean(EhCacheCacheManager.class);
    private static final String EHCACHE_NAME = "party-user-cache";
    private static final String KEY_PREFIX = "user_";

    public static Long getUserId() {
        return UcUtils.getUserId(false);
    }

    public static Long getUserId(boolean anonymous) {
        BaseUserInfo baseUserInfo = RestContext.getCurrertUserInfo();
        if (baseUserInfo == null) {
            if (anonymous) {
                return null;
            }
            throw new RestSimpleException(HttpStatus.FORBIDDEN, "REST/ACCESS_DENIED", "\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c");
        }
        return baseUserInfo.getUserId();
    }

    public static UcUserToken getUcToken() {
        return RestContext.getCurrentToken();
    }

    public static BaseUserInfo getUserInfo() {
        return RestContext.getCurrertUserInfo();
    }

    public static <T> T getLocalUser(Long userId, Class<T> clazz) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        Cache.ValueWrapper value = cache.get((Object)UcUtils.getKey(userId));
        if (value == null) {
            return null;
        }
        return (T)value.get();
    }

    public static <T> T getLocalUser(Class<T> clazz) {
        return UcUtils.getLocalUser(UcUtils.getUserId(), clazz);
    }

    public static void setLocalUser(Long userId, Object value) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        if (value != null) {
            cache.put((Object)UcUtils.getKey(userId), value);
        }
    }

    public static void setLocalUser(Object value) {
        Long userId = UcUtils.getUserId();
        UcUtils.setLocalUser(userId, value);
    }

    public static String getKey(Long userId) {
        return KEY_PREFIX + userId;
    }
}

