/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.beans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class QueryParameter {
    public static final String ASC = "asc";
    public static final String DESC = "desc";
    protected int pageNo = 1;
    protected int pageSize = 1;
    protected int offset = 0;
    protected String orderBy = "";
    protected boolean autoCount = true;
    protected Map<String, String> alias = new HashMap<String, String>();

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        if (pageSize == null || pageSize < 1) {
            pageSize = 10;
        }
        this.pageSize = pageSize;
    }

    @JsonIgnore
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @JsonIgnore
    public boolean isPageSizeSetted() {
        return this.pageSize > -1;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(Integer pageNo) {
        if (pageNo == null || pageNo < 1) {
            pageNo = 1;
        }
        this.pageNo = pageNo;
    }

    @JsonIgnore
    public int getFirst() {
        int first = 0;
        if (this.pageNo > 0 && this.pageSize > 0) {
            first = (this.pageNo - 1) * this.pageSize;
        }
        if (this.offset != 0) {
            first += this.offset;
        }
        return first;
    }

    @JsonIgnore
    public boolean isFirstSetted() {
        return this.pageNo > 0 && this.pageSize > 0;
    }

    @JsonIgnore
    public String getOrderBy() {
        return this.orderBy;
    }

    @JsonIgnore
    public boolean isOrderBySetted() {
        return StringUtils.isNotBlank((String)this.orderBy);
    }

    public void setOrderBy(String orderBy) {
        if (orderBy != null && !"".equals(orderBy)) {
            String[] orders;
            for (String orderStr : orders = StringUtils.split((String)orderBy, (char)',')) {
                String[] arr = orderStr.split("\\s+");
                if (StringUtils.equals((String)DESC, (String)arr[1]) || StringUtils.equals((String)ASC, (String)arr[1])) continue;
                throw new IllegalArgumentException("\u6392\u5e8f\u65b9\u5411" + orderStr + "\u4e0d\u662f\u5408\u6cd5\u503c");
            }
            this.orderBy = orderBy.trim();
        }
    }

    @JsonIgnore
    public boolean isAutoCount() {
        return this.autoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.autoCount = autoCount;
    }

    public void addAlias(String name, String alias) {
        this.alias.put(name, alias);
    }

    @JsonIgnore
    public boolean hasAlias() {
        return !this.alias.isEmpty();
    }

    @JsonIgnore
    public Map<String, String> getAlias() {
        return this.alias;
    }
}

