/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.servlet.http.HttpServletResponse;
import org.patchca.color.ColorFactory;
import org.patchca.filter.FilterFactory;
import org.patchca.filter.predefined.CurvesRippleFilterFactory;
import org.patchca.filter.predefined.DiffuseRippleFilterFactory;
import org.patchca.filter.predefined.DoubleRippleFilterFactory;
import org.patchca.filter.predefined.MarbleRippleFilterFactory;
import org.patchca.filter.predefined.WobbleRippleFilterFactory;
import org.patchca.service.CaptchaService;
import org.patchca.service.ConfigurableCaptchaService;
import org.patchca.utils.encoder.EncoderHelper;
import org.patchca.word.RandomWordFactory;
import org.patchca.word.WordFactory;

public class CaptchaUtil {
    private static ConfigurableCaptchaService cs = new ConfigurableCaptchaService();
    private static Random random = new Random();

    public static String generate(HttpServletResponse response) throws IOException {
        switch (random.nextInt(5)) {
            case 0: {
                cs.setFilterFactory((FilterFactory)new CurvesRippleFilterFactory(cs.getColorFactory()));
                break;
            }
            case 1: {
                cs.setFilterFactory((FilterFactory)new MarbleRippleFilterFactory());
                break;
            }
            case 2: {
                cs.setFilterFactory((FilterFactory)new DoubleRippleFilterFactory());
                break;
            }
            case 3: {
                cs.setFilterFactory((FilterFactory)new WobbleRippleFilterFactory());
                break;
            }
            case 4: {
                cs.setFilterFactory((FilterFactory)new DiffuseRippleFilterFactory());
            }
        }
        CaptchaUtil.setResponseHeaders(response);
        return EncoderHelper.getChallangeAndWriteImage((CaptchaService)cs, (String)"png", (OutputStream)response.getOutputStream());
    }

    private static void setResponseHeaders(HttpServletResponse response) {
        response.setContentType("image/png");
        response.setHeader("Cache-Control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        long time = System.currentTimeMillis();
        response.setDateHeader("Last-Modified", time);
        response.setDateHeader("Date", time);
        response.setDateHeader("Expires", time);
    }

    static {
        cs.setColorFactory(new ColorFactory(){

            public Color getColor(int x) {
                int[] c = new int[3];
                int i = random.nextInt(c.length);
                for (int fi = 0; fi < c.length; ++fi) {
                    c[fi] = fi == i ? random.nextInt(71) : random.nextInt(256);
                }
                return new Color(c[0], c[1], c[2]);
            }
        });
        RandomWordFactory wf = new RandomWordFactory();
        wf.setCharacters("23456789abcdefghigkmnpqrstuvwxyzABCDEFGHIGKLMNPQRSTUVWXYZ");
        wf.setMaxLength(4);
        wf.setMinLength(4);
        cs.setWordFactory((WordFactory)wf);
    }
}

