/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils.http;

import com.alibaba.fastjson.JSON;
import com.crawler.util.JsonMapper;
import com.crawler.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class SimpleHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private static CloseableHttpClient httpClient;
    private static CookieStore cookieStore;

    public static String getCookie(String name) {
        List cookies = cookieStore.getCookies();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static String get(String url) {
        return SimpleHttpClient.get(url, null);
    }

    public static String get(String url, Map<String, String> headers) {
        try {
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.90 Safari/537.36");
            if (headers != null) {
                SimpleHttpClient.addHeaders((HttpRequestBase)httpGet, headers);
            }
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException | ParseException ex) {
            LOGGER.error(ex.getMessage(), ex);
            return "";
        }
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> headers) {
        try {
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(SimpleHttpClient.getParam(params), "UTF-8");
            httpPost.setEntity((HttpEntity)postEntity);
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.90 Safari/537.36");
            if (headers != null) {
                SimpleHttpClient.addHeaders((HttpRequestBase)httpPost, headers);
            }
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException ex) {
            LOGGER.error(ex.getMessage(), ex);
            return "";
        }
    }

    public static String post(String url) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return SimpleHttpClient.post(url, params, null);
    }

    public static <T> T getForObject(String url, Class<T> clazz) {
        try {
            return SimpleHttpClient.toBean(SimpleHttpClient.get(url), clazz);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static <T> T getForObject(String url, Class<T> clazz, Map<String, String> headers) {
        try {
            return SimpleHttpClient.toBean(SimpleHttpClient.get(url, headers), clazz);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static <T> T postForObject(String url, Class<T> clazz) {
        try {
            return SimpleHttpClient.toBean(SimpleHttpClient.post(url), clazz);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static List<NameValuePair> getParam(Map<String, Object> parameterMap) {
        ArrayList<NameValuePair> param = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            param.add((NameValuePair)new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        return param;
    }

    private static void addHeaders(HttpRequestBase httpRequest, Map<String, String> headerMap) {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private static <T> T toBean(String response, Class<T> clazz) {
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(JsonMapper.getMapper());
        return (T)messageConverter.getObjectMapper().convertValue(JSON.parse((String)StringUtils.UrlDecode(response)), clazz);
    }

    static {
        cookieStore = new BasicCookieStore();
        httpClient = HttpClients.custom().setDefaultCookieStore(cookieStore).build();
    }
}

