/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils.http;

import com.alibaba.fastjson.JSON;
import com.crawler.util.JsonMapper;
import com.crawler.utils.StringUtils;
import com.crawler.utils.http.SimpleHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class WebClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private CloseableHttpClient httpClient;
    private CookieStore cookieStore = new BasicCookieStore();

    public WebClient() {
        this.httpClient = HttpClients.custom().setDefaultCookieStore(this.cookieStore).build();
    }

    public String getCookie(String name) {
        List cookies = this.cookieStore.getCookies();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public String get(String url) {
        return this.get(url, null);
    }

    public String get(String url, Map<String, String> headers) {
        HttpGet httpGet = new HttpGet(url);
        if (headers != null) {
            WebClient.addHeaders((HttpRequestBase)httpGet, headers);
        }
        String content = "";
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
            content = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException | ParseException ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
        return content;
    }

    public String post(String url, Map<String, Object> params, Map<String, String> headers) {
        String content = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(WebClient.getParam(params), "UTF-8");
            httpPost.setEntity((HttpEntity)postEntity);
            if (headers != null) {
                WebClient.addHeaders((HttpRequestBase)httpPost, headers);
            }
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
        return content;
    }

    public String post(String url) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.post(url, params, null);
    }

    public <T> T getForObject(String url, Class<T> clazz) {
        try {
            return WebClient.toBean(this.get(url), clazz);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public <T> T getForObject(String url, Class<T> clazz, Map<String, String> headers) {
        try {
            return WebClient.toBean(this.get(url, headers), clazz);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public <T> T postForObject(String url, Class<T> clazz) {
        try {
            return WebClient.toBean(this.post(url), clazz);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static List<NameValuePair> getParam(Map<String, Object> parameterMap) {
        ArrayList<NameValuePair> param = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            param.add((NameValuePair)new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        return param;
    }

    private static void addHeaders(HttpRequestBase httpRequest, Map<String, String> headerMap) {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private static <T> T toBean(String response, Class<T> clazz) {
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(JsonMapper.getMapper());
        return (T)messageConverter.getObjectMapper().convertValue(JSON.parse((String)StringUtils.UrlDecode(response)), clazz);
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }
}

