package com.crawler.component;

import javax.servlet.ServletContext;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

/** 
 * 
 * 获取spring容器，以访问容器中定义的其他bean 
 * @author rubekid
 */
@Component
@Order(1)
public class SpringContextUtil implements ApplicationContextAware, ServletContextAware {

	/**
	 * Spring应用上下文环境
	 */
	private static ApplicationContext applicationContext;
	
	/**
	 * Servlet 上下文环境
	 */
	private static ServletContext servletContext;

	/**
	 * 实现ApplicationContextAware接口的回调方法，设置上下文环境
	 * 
	 * @param applicationContext
	 */
	public void setApplicationContext(ApplicationContext applicationContext) {
		SpringContextUtil.applicationContext = applicationContext;
	}

	/**
	 * @return ApplicationContext
	 */
	public static ApplicationContext getApplicationContext() {
		return applicationContext;
	}

	@Override
	public void setServletContext(ServletContext servletContext) {
		SpringContextUtil.servletContext = servletContext;
	}
	
	public static ServletContext getServletContext() {
		return servletContext;
	}
	
	/**
	 * 获取对象
	 * 这里重写了bean方法，起主要作用
	 * @param <T>
	 * @param name
	 * @return Object 一个以所给名字注册的bean的实例
	 * @throws BeansException
	 */
	public static <T> T getBean(Class<T> clazz) throws BeansException {
		return (T) applicationContext.getBean(clazz);
	}

}