package com.crawler.utils;

import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.http.HttpStatus;

import com.crawler.component.SpringContextUtil;
import com.crawler.rest.exceptions.extendExceptions.RestSimpleException;
import com.crawler.rest.security.authens.BaseUserInfo;
import com.crawler.rest.security.authens.UcUserToken;
import com.crawler.rest.support.RestContext;

/**
 * UC 工具
 * @author rubekid
 * @date 2016年7月12日
 */
public class UcUtils {
	
	/**
	 * CacheManager
	 */
	private static EhCacheCacheManager cacheManager = SpringContextUtil.getBean(EhCacheCacheManager.class);
	
	/**
	 * 缓存名称
	 */
	private final static String EHCACHE_NAME = "party-user-cache";
    
	/**
	 * 前缀
	 */
    private final static String KEY_PREFIX = "user_";

	
	/**
	 * 获取当前用户
	 * @return
	 */
	public static Long getUserId(){
		return getUserId(false);
	}
	
	/**
	 * 获取当前用户id（允许游客）
	 * @return
	 */
	public static Long getUserId(boolean anonymous){
		BaseUserInfo baseUserInfo = RestContext.getCurrertUserInfo();
		if(baseUserInfo == null){
			if(anonymous){
				return null;
			}
			throw new RestSimpleException(HttpStatus.FORBIDDEN, "REST/ACCESS_DENIED", "请登录后操作");
		}
		return baseUserInfo.getUserId();
	}
	
	
	public static UcUserToken  getUcToken(){
		return RestContext.getCurrentToken(); 
	}
	
	/**
	 * 返回用户信息
	 * @return
	 */
	public static BaseUserInfo getUserInfo(){
		return RestContext.getCurrertUserInfo();
	}
	
	/**
	 * 返回本地用户信息
	 */
	public static <T> T getLocalUser(Long userId, Class<T> clazz){
		Cache cache = cacheManager.getCache(EHCACHE_NAME);
        Cache.ValueWrapper value = cache.get(getKey(userId));
        if (value == null) {
            return null;
        }
        return (T) value.get();
	}
	
	/**
	 * 返回本地用户信息
	 */
	public static <T> T getLocalUser(Class<T> clazz){
		return getLocalUser(UcUtils.getUserId(), clazz);
	}


    
    /**
     * 设置缓存
     * @param key
     * @param value
     */
    public static void setLocalUser(Long userId, Object value) {
        Cache cache = cacheManager.getCache(EHCACHE_NAME);
        if(value!=null){
            cache.put(getKey(userId), value);
        }
    }

    /**
     * 设置缓存
     * @param value
     */
    public static void setLocalUser(Object value) {
        Long userId = getUserId();
        setLocalUser(userId, value);
    }
    
    
    /**
     * 缓存KEY
     * @param values
     * @return
     */
    public static String getKey(Long userId){
    	return KEY_PREFIX + userId;
    }

}
