package com.crawler.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

import com.crawler.common.config.UtilConstant;
import com.crawler.rest.exceptions.extendExceptions.RestSimpleException;
import com.crawler.rest.utils.Warner;
import com.crawler.utils.http.ClientCustomSSL;
import com.crawler.utils.http.HttpUtils;


/**
 * 微信
 * 
 * @author rubekid
 * @date 2016年9月11日
 */
public class WeixinUtils {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(WeixinUtils.class);


	/**
	 * 创建sign规则
	 * 
	 * @param parameters
	 * @return
	 * @throws UnsupportedEncodingException 
	 */
	public static String createSign(SortedMap<String, Object> parameters){
		return createSign(parameters, UtilConstant.WX_APP_KEY);
	}
	
	/**
	 *  创建sign规则
	 * @param parameters
	 * @param appKey
	 * @return
	 */
	public static String createSign(SortedMap<String, Object> parameters, String appKey){
		StringBuffer sb = new StringBuffer();
		for (Map.Entry<String, Object> entry : parameters.entrySet()) {
			String key = entry.getKey();
			String value = String.valueOf(entry.getValue());
			if (!"sign".equalsIgnoreCase(key) && !"key".equalsIgnoreCase(key) && !StringUtils.isNullOrEmpty(value)) {
				sb.append(key + "=" + value + "&");
			}
		}
		sb.append("key=" + appKey);
		return StringUtils.md5(sb.toString()).toUpperCase();
	}

	/**
	 * 构建请求对象为xml字符串
	 * 
	 * @param parameters
	 * @return
	 * @deprecated Use {@link #toXml(SortedMap<String, Object>)} instead
	 */
	public static String getRequestXml(SortedMap<String, Object> parameters) {
		return toXml(parameters);
	}

	/**
	 * 构建请求对象为xml字符串
	 * 
	 * @param parameters
	 * @return
	 */
	public static String toXml(SortedMap<String, Object> parameters) {
		StringBuffer sb = new StringBuffer();
		sb.append("<xml>");
		for (Map.Entry<String, Object> entry : parameters.entrySet()) {
			String key = entry.getKey();
			String value = String.valueOf(entry.getValue());
			if ("attach".equalsIgnoreCase(key) || "body".equalsIgnoreCase(key) || "sign".equalsIgnoreCase(key)) {
				sb.append("<" + key + ">" + "<![CDATA[" + value + "]]></" + key + ">");
			} else {
				sb.append("<" + key + ">" + value + "</" + key + ">");
			}
		}
		sb.append("</xml>");
		return sb.toString();
	}

	/**
	 * 解析xml
	 * 
	 * @param xml
	 * @return
	 * @throws JDOMException
	 * @throws IOException
	 */
	public static SortedMap<String, String> doXMLParse(String xml) throws JDOMException, IOException{
		if(xml == null){
			return null;
		}
		xml = xml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"");
		if (null == xml || "".equals(xml)) {
			return null;
		}
		SortedMap<String, String> map = new TreeMap<String, String>();
		InputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
		SAXBuilder builder = new SAXBuilder();
		Document doc = builder.build(in);
		Element root = doc.getRootElement();
		List<Element> list = root.getChildren();
		Iterator<Element> it = list.iterator();
		while (it.hasNext()) {
			Element e = (Element) it.next();
			String key = e.getName();
			String value = "";
			List<Element> children = e.getChildren();
			if (children.isEmpty()) {
				value = e.getTextNormalize();
			} else {
				value = getChildrenText(children);
			}
			map.put(key, value);
		}
		in.close();
		return map;
	}

	/**
	 * 获取子结点的xml
	 * 
	 * @param children
	 * @return String
	 */
	public static String getChildrenText(List<Element> children) {
		StringBuffer sb = new StringBuffer();
		if (!children.isEmpty()) {
			Iterator<Element> it = children.iterator();
			while (it.hasNext()) {
				Element e = (Element) it.next();
				String name = e.getName();
				String value = e.getTextNormalize();
				List<Element> list = e.getChildren();
				sb.append("<" + name + ">");
				if (!list.isEmpty()) {
					sb.append(getChildrenText(list));
				}
				sb.append(value);
				sb.append("</" + name + ">");
			}
		}
		return sb.toString();
	}

	/**
	 * 设置xml
	 * 
	 * @param return_code
	 * @param return_msg
	 * @return
	 */
	public static String setXML(String return_code, String return_msg) {
		return "<xml><return_code><![CDATA[" + return_code + "]]></return_code><return_msg><![CDATA[" + return_msg
				+ "]]></return_msg></xml>";
	}
	
	
	/**
	 * 签名校验
	 * @param map
	 * @return
	 */
	public static boolean checkSign(SortedMap<String, String> map){
		String wxsign = String.valueOf(map.get("sign"));
		StringBuffer sb = new StringBuffer();
		for(Entry<String, String> entry : map.entrySet()){
			String k = entry.getKey();
			String v = entry.getValue();
			if(!"sign".equals(k) && null != v && !"".equals(v)) {
				sb.append(k + "=" + v + "&");
			}
		}
		//算出摘要
		String sign = StringUtils.md5(sb.toString() + "key=" + UtilConstant.WX_APP_KEY).toLowerCase();
		
		return wxsign.equalsIgnoreCase(sign);
	}
	
	/**
	 * 随机
	 * @return
	 */
	public static String  nonceStr(){
		return StringUtils.md5(String.valueOf(System.currentTimeMillis()));
	}
	
	/**
	 * 成功返回
	 * @return
	 */
	public static String successResponse(){
		SortedMap<String, Object> response = new TreeMap<String, Object>();
		response.put("return_code", "SUCCESS");
		response.put("return_msg", "OK");
    	return toXml(response);
	}
	
	/**
	 * 微信统一下单
	 * @param request
	 * @param orderNo
	 * @param detail
	 * @param totalFee
	 * @param tradeType
	 * @param openId
	 * @return
	 * @throws JDOMException
	 * @throws IOException
	 */
	public static SortedMap<String,Object>  unifiedOrder(HttpServletRequest request, String orderNo, String detail, BigDecimal totalFee, String openId) throws JDOMException, IOException{
		String notifyUrl = WebUtils.getBaseUrl(request) + UtilConstant.WXNOTIFY_URL;
		//****************************** 统一下单 start****************************//*
		SortedMap<String,Object> parameters = new TreeMap<String, Object>();
		parameters.put("appid", UtilConstant.WX_APP_ID);
		parameters.put("mch_id",UtilConstant.WX_MCH_ID);
		if(openId!=null){
			 parameters.put("openid", openId);
		}
		parameters.put("nonce_str", WeixinUtils.nonceStr());
		parameters.put("body",detail);
		parameters.put("out_trade_no",orderNo);
		parameters.put("total_fee",new Double((totalFee.doubleValue()*100)).intValue());
		parameters.put("spbill_create_ip", IpAddressUtils.getIpAddress(request));
		parameters.put("notify_url", notifyUrl);
		parameters.put("trade_type", "JSAPI");//调用APP支付
		String sign = WeixinUtils.createSign(parameters);
		parameters.put("sign", sign);
		String requestXML = WeixinUtils.toXml(parameters);
		System.out.println("==================统一下单=========================");
		System.out.println(requestXML);
		System.out.println("==================统一下单=========================");
		//*******************************统一下单 end
		
		
		//调用统一下单接口接收返回数据
		String response = HttpUtils.httpsRequest(UtilConstant.WX_UNIFIED_ORDER, HttpMethod.POST, requestXML);
		//微信返回的信息
		Map<String, String> map = WeixinUtils.doXMLParse(response);
		SortedMap<String,Object> params = null;
		if("SUCCESS".equals(map.get("result_code"))){
			params=new TreeMap<String, Object>();
			params.put("appId",UtilConstant.WX_APP_ID);
			params.put("timeStamp",DateUtils.getShortDate());
			params.put("nonceStr", WeixinUtils.createSign(params));
			params.put("package", "prepay_id=" + map.get("prepay_id"));
			params.put("signType", "MD5");
			params.put("paySign",WeixinUtils.createSign(params));
		}
		else{
			System.out.println(response);
			throw new RestSimpleException("微信统一下单失败");
		}
		
		return params;
	}
	
	
	/**
	 * 微信统一下单
	 * @param request
	 * @param orderNo
	 * @param detail
	 * @param totalFee
	 * @return
	 * @throws JDOMException
	 * @throws IOException
	 */
	public static SortedMap<String,Object>  unifiedOrder(HttpServletRequest request, String orderNo, String detail, BigDecimal totalFee) throws JDOMException, IOException{
		String notifyUrl = WebUtils.getBaseUrl(request) + UtilConstant.WXNOTIFY_URL;
		//****************************** 统一下单 start****************************//*
		SortedMap<String,Object> parameters = new TreeMap<String, Object>();
		parameters.put("appid", UtilConstant.WX_APP_ID);
		parameters.put("mch_id",UtilConstant.WX_MCH_ID);
		parameters.put("nonce_str", WeixinUtils.nonceStr());
		parameters.put("body",detail);
		parameters.put("out_trade_no",orderNo);
		parameters.put("total_fee",new Double((totalFee.doubleValue()*100)).intValue());
		parameters.put("spbill_create_ip", IpAddressUtils.getIpAddress(request));
		parameters.put("notify_url", notifyUrl);
		parameters.put("trade_type", "APP");//调用APP支付
		String sign = WeixinUtils.createSign(parameters);
		parameters.put("sign", sign);
		String requestXML = WeixinUtils.toXml(parameters);
		//*******************************统一下单 end
		
		
		//调用统一下单接口接收返回数据
		String response = HttpUtils.httpsRequest(UtilConstant.WX_UNIFIED_ORDER, HttpMethod.POST, requestXML);
		//微信返回的信息
		Map<String, String> map = WeixinUtils.doXMLParse(response);
		SortedMap<String,Object> params = null;
		if("SUCCESS".equals(map.get("result_code"))){
			params=new TreeMap<String, Object>();
			params.put("appid",UtilConstant.WX_APP_ID);
			params.put("partnerid",UtilConstant.WX_MCH_ID);
			params.put("prepayid",map.get("prepay_id"));    //这里用
			params.put("noncestr", WeixinUtils.createSign(params));
			params.put("timestamp",DateUtils.getShortDate());
			params.put("package", "Sign=WXPay");
			params.put("sign",WeixinUtils.createSign(params));

		}
		else{
			throw new RestSimpleException("微信统一下单失败");
		}
		
		return params;
	}
	
	/**
	 * 退款处理
	 * @param orderNo 
	 * @param tradeNo
	 * @param refundNo
	 * @param fee
	 * @param userId
	 * @return
	 */
	public static boolean refund(String orderNo, String tradeNo, String refundNo, BigDecimal fee, Long userId){
		SortedMap<String,Object> parameters = new TreeMap<String, Object>();
		parameters.put("appid", UtilConstant.WX_APP_ID);
		parameters.put("mch_id",UtilConstant.WX_MCH_ID);
		parameters.put("nonce_str", WeixinUtils.nonceStr());
		if(orderNo != null){
			parameters.put("out_trade_no", orderNo);
		}
		Long value = fee.multiply(BigDecimal.valueOf(100L)).longValue();
		parameters.put("out_refund_no", refundNo);
		parameters.put("total_fee", value);
		parameters.put("refund_fee", value);
		parameters.put("op_user_id", userId);
		parameters.put("transaction_id", tradeNo);
		
		String sign = WeixinUtils.createSign(parameters);
		parameters.put("sign", sign);
		String requestXML = WeixinUtils.toXml(parameters);
		
		try {
			String response = ClientCustomSSL.doRefund(UtilConstant.WX_REFUND, requestXML);
			System.out.println("=======================微信退款======================");
			System.out.println(response);
			Map<String, String> map = WeixinUtils.doXMLParse(response);
			if("SUCCESS".equals(map.get("return_code"))){
				return true;
			}
		} catch (JDOMException | KeyManagementException | UnrecoverableKeyException 
				| NoSuchAlgorithmException | CertificateException | KeyStoreException | IOException e) {
			System.out.println(e.getMessage());
			Warner.send("微信退款失败：" + e.getMessage());
			throw new RestSimpleException("微信退款失败");
			
		}
		return false;
	}

}