package com.crawler.utils;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jdom2.JDOMException;


public class XmlUtils {

	/**
	 * 解析xml
	 * 
	 * @param xml
	 * @return
	 * @throws JDOMException
	 * @throws IOException
	 * @throws DocumentException 
	 */
	public static SortedMap<String, String> doXMLParse(String xml) throws JDOMException, IOException, DocumentException{
		if(xml == null){
			return null;
		}
		xml = xml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"");
		if ("".equals(xml)) {
			return null;
		}
		SortedMap<String, String> map = new TreeMap<String, String>();
		Document doc = DocumentHelper.parseText(xml); 
		Element root = doc.getRootElement();
		List<Element> list = root.elements();
		Iterator<Element> it = list.iterator();
		while (it.hasNext()) {
			Element e = (Element) it.next();
			String key = e.getName();
			String value = "";
			List<Element> children = e.elements();
			if (children.isEmpty()) {
				value = e.getTextTrim();
			} else {
				value = getChildrenText(children);
			}
			map.put(key, value);
		}
		return map;
	}
	
	/**
	 * 获取子结点的xml
	 * 
	 * @param children
	 * @return String
	 */
	public static String getChildrenText(List<Element> children) {
		StringBuffer sb = new StringBuffer();
		if (!children.isEmpty()) {
			Iterator<Element> it = children.iterator();
			while (it.hasNext()) {
				Element e = (Element) it.next();
				String name = e.getName();
				String value = e.getTextTrim();
				List<Element> list = e.elements();
				sb.append("<" + name + ">");
				if (!list.isEmpty()) {
					sb.append(getChildrenText(list));
				}
				sb.append(value);
				sb.append("</" + name + ">");
			}
		}
		return sb.toString();
	}
}
