/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.client.http.RestHttpClient;
import com.crawler.common.config.UtilProperties;
import com.crawler.rest.utils.Warner;
import com.crawler.utils.StringUtils;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiNiuUtils {
    private static final Logger logger = LoggerFactory.getLogger(UtilProperties.class);
    private static Properties properties;
    public static final String DOMAIN;
    private static final String ACCESS_KEY;
    private static final String SECRET_KEY;
    private static final String BUCKET_NAME;
    private static final Auth auth;

    public static String getUpToken() {
        return auth.uploadToken(BUCKET_NAME, null, 360000L, null, true);
    }

    public static String getUpToken(String buketName) {
        return auth.uploadToken(buketName, null, 360000L, null, true);
    }

    public static void upload(byte[] data, String fileName) throws IOException {
        try {
            UploadManager uploadManager = new UploadManager();
            Response res = uploadManager.put(data, fileName, QiNiuUtils.getUpToken());
            System.out.println(res.bodyString());
        }
        catch (QiniuException e) {
            Response r = e.response;
            System.out.println(r.toString());
            try {
                Warner.send((String)r.bodyString());
            }
            catch (QiniuException qiniuException) {
                // empty catch block
            }
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static JSONObject imageInfo(String url) {
        RestHttpClient client = new RestHttpClient();
        JSONObject json = (JSONObject)client.getForObject(url + "?imageInfo", JSONObject.class, new Object[0]);
        return json;
    }

    public static String transfer(String url, String fileName) throws IOException {
        byte[] types;
        if (fileName == null) {
            fileName = StringUtils.uniqueId() + url.substring(url.lastIndexOf("."));
        }
        if ((types = QiNiuUtils.toByte(url)) == null) {
            return null;
        }
        QiNiuUtils.upload(types, fileName);
        return DOMAIN + "/" + fileName;
    }

    public static String transfer(String url) throws IOException {
        return QiNiuUtils.transfer(url, null);
    }

    private static byte[] toByte(String urlString) {
        try {
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(5000);
            InputStream is = con.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            is.close();
            return output.toByteArray();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    static {
        try {
            properties = UtilProperties.getProperties();
            InputStream stream = QiNiuUtils.class.getClassLoader().getResourceAsStream("qiniu.properties");
            if (stream != null) {
                properties.load(stream);
            }
        }
        catch (Exception ex) {
            logger.warn("Read config.properties error.", (Throwable)ex);
        }
        DOMAIN = properties.getProperty("qiniu.domain");
        ACCESS_KEY = properties.getProperty("qiniu.access_key");
        SECRET_KEY = properties.getProperty("qiniu.secret_key");
        BUCKET_NAME = properties.getProperty("qiniu.bucket");
        auth = Auth.create((String)ACCESS_KEY, (String)SECRET_KEY);
    }
}

