/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.crawler.beans.Page;
import com.crawler.rest.utils.Warner;
import com.crawler.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class RedisManager {
    private static Logger logger = LoggerFactory.getLogger(RedisManager.class);
    private static int TIMEOUT_MSECS = 60000;
    private static int LOCK_EXPIRE_MSECS = 60000;
    private static JedisPool pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lock(String lockKey) {
        long start = System.currentTimeMillis();
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            int timeout = TIMEOUT_MSECS;
            while (timeout >= 0) {
                String oldValue;
                long time = System.currentTimeMillis() + (long)LOCK_EXPIRE_MSECS + 1L;
                String expireAt = String.valueOf(time);
                if (jedis.setnx(lockKey, expireAt) == 1L) {
                    boolean bl = true;
                    return bl;
                }
                String currentValue = jedis.get(lockKey);
                if (currentValue != null && Long.parseLong(currentValue) < System.currentTimeMillis() && (oldValue = jedis.getSet(lockKey, expireAt)) != null && oldValue.equals(currentValue)) {
                    boolean bl = true;
                    return bl;
                }
                timeout -= 100;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    Warner.send((String)("RedisManager.lock Thread.sleep \u5f02\u5e38\uff1a" + ex.getMessage()));
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
            System.out.println("\u83b7\u53d6redis\u9501\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        }
    }

    public static void unlock(String lockKey) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.del(lockKey);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchDeleteByKey(String prefix) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            Set set = jedis.keys(prefix + "*");
            Iterator it = set.iterator();
            ArrayList keys = new ArrayList();
            while (it.hasNext()) {
                keys.add(it.next());
                if (keys.size() <= 0 || keys.size() % 100 != 0) continue;
                jedis.del(keys.toArray(new String[keys.size()]));
                keys.clear();
            }
            if (keys.size() > 0) {
                jedis.del(keys.toArray(new String[keys.size()]));
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static Jedis getJedis() {
        return pool.getResource();
    }

    public static void close(Jedis jedis) {
        jedis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key, String defaultValue) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            String value = jedis.get(key);
            String string = value == null ? defaultValue : value;
            return string;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static void set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.set(key, value);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(String key, Class<T> clazz) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            JSONObject json = JSONObject.parseObject((String)jedis.get(key));
            Object object = json.toJavaObject(clazz);
            return (T)object;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> findList(String key, Class<T> clazz, String ... exceptKeys) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            List data = new ArrayList();
            if (key.contains("*")) {
                Set keys = jedis.keys(key);
                List<String> exceptKeyList = Arrays.asList(exceptKeys);
                for (String k : keys) {
                    if (exceptKeyList.contains(k)) continue;
                    data.addAll(jedis.lrange(k, 0L, -1L));
                }
            } else {
                data = jedis.lrange(key, 0L, -1L);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (String string : data) {
                list.add(JSONObject.parseObject((String)string).toJavaObject(clazz));
            }
            ArrayList<Object> arrayList = list;
            return arrayList;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Page<T> findPage(Page<T> page, String key) {
        Jedis jedis = null;
        try {
            int start = page.getFirst();
            int end = start + page.getPageSize();
            jedis = RedisManager.getJedis();
            List data = jedis.lrange(key, (long)start, (long)end);
            ArrayList<Object> list = new ArrayList<Object>();
            for (String string : data) {
                list.add(JSONObject.parseObject((String)string).toJavaObject(T.class));
            }
            page.setItems(list);
            Page<T> page2 = page;
            return page2;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static void put(String key, Object data) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.set(key, JSONObject.toJSONString((Object)data));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> void setList(String key, List<E> list) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.del(key);
            String[] strings = StringUtils.toStrings(list);
            if (strings.length > 0) {
                jedis.rpush(key, strings);
            } else {
                Warner.send((String)("redis \u53c2\u6570\u6709\u8bef" + JSON.toJSONString(list)));
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static void insert(String key, Object item) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.rpush(key, new String[]{JSONObject.toJSONString((Object)item)});
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> keys(String pattern) {
        Jedis jedis = null;
        try {
            Set keys;
            jedis = RedisManager.getJedis();
            Set set = keys = jedis.keys(pattern);
            return set;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static void set(String key, Object obj) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.set(key, JSONObject.toJSONString((Object)obj));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lset(String key, int index, Object obj) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.lset(key, (long)index, JSONObject.toJSONString((Object)obj));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static void remove(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.del(key);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(String channel, Object obj) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            String data = JSONObject.toJSONString((Object)obj);
            System.out.println("================== \u53d1\u5e03\u6d88\u606f ========================");
            System.out.println(channel + " " + data);
            jedis.publish(channel, data);
            System.out.println("================== \u53d1\u5e03\u6d88\u606f\u7ed3\u675f ========================");
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        Jedis jedis = null;
        try {
            jedis = RedisManager.getJedis();
            jedis.subscribe(jedisPubSub, channels);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    static {
        try {
            Properties props = new Properties();
            props.load(RedisManager.class.getClassLoader().getResourceAsStream("redis.properties"));
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(Integer.valueOf(props.getProperty("jedis.pool.maxTotal")).intValue());
            config.setMaxIdle(Integer.valueOf(props.getProperty("jedis.pool.maxIdle")).intValue());
            config.setMaxWaitMillis(Long.valueOf(props.getProperty("jedis.pool.maxWaitMillis")).longValue());
            config.setTestOnBorrow(Boolean.valueOf(props.getProperty("jedis.pool.testOnBorrow")).booleanValue());
            config.setTestOnReturn(Boolean.valueOf(props.getProperty("jedis.pool.testOnReturn")).booleanValue());
            String ip = props.getProperty("redis.ip");
            Integer port = Integer.valueOf(props.getProperty("redis.port"));
            Integer expire = Integer.valueOf(props.getProperty("redis.expire"));
            String password = props.getProperty("redis.password");
            pool = password != null ? new JedisPool((GenericObjectPoolConfig)config, ip, port.intValue(), expire.intValue(), password) : new JedisPool((GenericObjectPoolConfig)config, ip, port.intValue(), expire.intValue());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

