/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.utils;

import com.crawler.common.config.UtilConstant;
import com.crawler.component.SpringContextUtil;
import javax.servlet.http.HttpServletRequest;

public class WebUtils {
    public static String getContextPath() {
        return SpringContextUtil.getServletContext().getRealPath("/");
    }

    public static String getUploadPath() {
        return WebUtils.getContextPath() + UtilConstant.UPLOAD_PATH;
    }

    public static String getBaseUrl(HttpServletRequest request) {
        String baseUrl = UtilConstant.BASE_URL;
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = request.getRequestURL().toString().replace(request.getRequestURI(), "");
        }
        return baseUrl;
    }

    public static String getUrl(HttpServletRequest request) {
        String url = request.getProtocol() + " ://" + request.getServerName();
        if (request.getServerPort() != 80) {
            url = url + ":" + request.getServerPort();
        }
        url = url + request.getContextPath() + request.getServletPath() + "?" + request.getQueryString();
        return url;
    }

    public static String getBasePath(HttpServletRequest request) {
        String url = request.getScheme() + "://" + request.getServerName();
        if (request.getServerPort() != 80) {
            url = url + ":" + request.getServerPort();
        }
        url = url + request.getContextPath();
        return url;
    }
}

