/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.security.shiro.session;

import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.security.shiro.session.SessionDAO;
import com.crawler.waqf.common.utils.DateUtils;
import com.crawler.waqf.common.utils.JedisUtils;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.common.web.Servlets;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class JedisSessionDAO
extends AbstractSessionDAO
implements SessionDAO {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String sessionKeyPrefix = "shiro_session_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Session session) throws UnknownSessionException {
        if (session == null || session.getId() == null) {
            return;
        }
        HttpServletRequest request = Servlets.getRequest();
        if (request != null) {
            String uri = request.getServletPath();
            if (Servlets.isStaticFile(uri)) {
                return;
            }
            if (StringUtils.startsWith((CharSequence)uri, (CharSequence)Global.getConfig("web.view.prefix")) && StringUtils.endsWith((CharSequence)uri, (CharSequence)Global.getConfig("web.view.suffix"))) {
                return;
            }
            if ("0".equals(request.getParameter("updateSession"))) {
                return;
            }
        }
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            String principalId = pc != null ? pc.getPrimaryPrincipal().toString() : "";
            jedis.hset(this.sessionKeyPrefix, session.getId().toString(), principalId + "|" + session.getTimeout() + "|" + session.getLastAccessTime().getTime());
            jedis.set(JedisUtils.getBytesKey(this.sessionKeyPrefix + session.getId()), JedisUtils.toBytes(session));
            int timeoutSeconds = (int)(session.getTimeout() / 1000L);
            jedis.expire(this.sessionKeyPrefix + session.getId(), timeoutSeconds);
            this.logger.debug("update {} {}", (Object)session.getId(), (Object)(request != null ? request.getRequestURI() : ""));
        }
        catch (Exception e) {
            this.logger.error("update {} {}", new Object[]{session.getId(), request != null ? request.getRequestURI() : "", e});
        }
        finally {
            JedisUtils.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            jedis.hdel(JedisUtils.getBytesKey(this.sessionKeyPrefix), (byte[][])new byte[][]{JedisUtils.getBytesKey(session.getId().toString())});
            jedis.del(JedisUtils.getBytesKey(this.sessionKeyPrefix + session.getId()));
            this.logger.debug("delete {} ", (Object)session.getId());
        }
        catch (Exception e) {
            this.logger.error("delete {} ", (Object)session.getId(), (Object)e);
        }
        finally {
            JedisUtils.returnResource(jedis);
        }
    }

    public Collection<Session> getActiveSessions() {
        return this.getActiveSessions(true);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave) {
        return this.getActiveSessions(includeLeave, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Session> getActiveSessions(boolean includeLeave, Object principal, Session filterSession) {
        HashSet sessions = Sets.newHashSet();
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            Map map = jedis.hgetAll(this.sessionKeyPrefix);
            for (Map.Entry e : map.entrySet()) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey())) && StringUtils.isNotBlank((CharSequence)((CharSequence)e.getValue()))) {
                    String[] ss = StringUtils.split((String)((String)e.getValue()), (String)"|");
                    if (ss != null && ss.length == 3) {
                        SimpleSession session = new SimpleSession();
                        session.setId((Serializable)e.getKey());
                        session.setAttribute((Object)"principalId", (Object)ss[0]);
                        session.setTimeout(Long.valueOf(ss[1]).longValue());
                        session.setLastAccessTime(new Date(Long.valueOf(ss[2])));
                        try {
                            session.validate();
                            boolean isActiveSession = false;
                            if (includeLeave || DateUtils.pastMinutes(session.getLastAccessTime()) <= 3L) {
                                isActiveSession = true;
                            }
                            if (principal != null) {
                                PrincipalCollection pc = (PrincipalCollection)session.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                                if (principal.toString().equals(pc != null ? pc.getPrimaryPrincipal().toString() : "")) {
                                    isActiveSession = true;
                                }
                            }
                            if (filterSession != null && filterSession.getId().equals(session.getId())) {
                                isActiveSession = false;
                            }
                            if (!isActiveSession) continue;
                            sessions.add(session);
                        }
                        catch (Exception e2) {
                            jedis.hdel(this.sessionKeyPrefix, new String[]{(String)e.getKey()});
                        }
                        continue;
                    }
                    jedis.hdel(this.sessionKeyPrefix, new String[]{(String)e.getKey()});
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey()))) continue;
                jedis.hdel(this.sessionKeyPrefix, new String[]{(String)e.getKey()});
            }
            this.logger.info("getActiveSessions size: {} ", (Object)sessions.size());
        }
        catch (Exception e) {
            this.logger.error("getActiveSessions", (Throwable)e);
        }
        finally {
            JedisUtils.returnResource(jedis);
        }
        return sessions;
    }

    protected Serializable doCreate(Session session) {
        String uri;
        HttpServletRequest request = Servlets.getRequest();
        if (request != null && Servlets.isStaticFile(uri = request.getServletPath())) {
            return null;
        }
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.update(session);
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session doReadSession(Serializable sessionId) {
        Session s = null;
        HttpServletRequest request = Servlets.getRequest();
        if (request != null) {
            String uri = request.getServletPath();
            if (Servlets.isStaticFile(uri)) {
                return null;
            }
            s = (Session)request.getAttribute("session_" + sessionId);
        }
        if (s != null) {
            return s;
        }
        Session session = null;
        Jedis jedis = null;
        try {
            jedis = JedisUtils.getResource();
            session = (Session)JedisUtils.toObject(jedis.get(JedisUtils.getBytesKey(this.sessionKeyPrefix + sessionId)));
            this.logger.debug("doReadSession {} {}", (Object)sessionId, (Object)(request != null ? request.getRequestURI() : ""));
        }
        catch (Exception e) {
            this.logger.error("doReadSession {} {}", new Object[]{sessionId, request != null ? request.getRequestURI() : "", e});
        }
        finally {
            JedisUtils.returnResource(jedis);
        }
        if (request != null && session != null) {
            request.setAttribute("session_" + sessionId, (Object)session);
        }
        return session;
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        try {
            return super.readSession(sessionId);
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    public String getSessionKeyPrefix() {
        return this.sessionKeyPrefix;
    }

    public void setSessionKeyPrefix(String sessionKeyPrefix) {
        this.sessionKeyPrefix = sessionKeyPrefix;
    }
}

