/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.security.shiro.session;

import com.crawler.waqf.common.utils.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.util.WebUtils;

public class SessionManager
extends DefaultWebSessionManager {
    protected Serializable getSessionId(ServletRequest request, ServletResponse response) {
        String sid = request.getParameter("__sid");
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            if (WebUtils.isTrue((ServletRequest)request, (String)"__cookie")) {
                HttpServletRequest rq = (HttpServletRequest)request;
                HttpServletResponse rs = (HttpServletResponse)response;
                Cookie template = this.getSessionIdCookie();
                SimpleCookie cookie = new SimpleCookie(template);
                cookie.setValue(sid);
                cookie.saveTo(rq, rs);
            }
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)"url");
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID, (Object)sid);
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_IS_VALID, (Object)Boolean.TRUE);
            return sid;
        }
        return super.getSessionId(request, response);
    }

    public void validateSessions() {
        super.validateSessions();
    }

    protected Session retrieveSession(SessionKey sessionKey) {
        try {
            return super.retrieveSession(sessionKey);
        }
        catch (UnknownSessionException e) {
            return null;
        }
    }

    public Date getStartTimestamp(SessionKey key) {
        try {
            return super.getStartTimestamp(key);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    public Date getLastAccessTime(SessionKey key) {
        try {
            return super.getLastAccessTime(key);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    public long getTimeout(SessionKey key) {
        try {
            return super.getTimeout(key);
        }
        catch (InvalidSessionException e) {
            return 0L;
        }
    }

    public void setTimeout(SessionKey key, long maxIdleTimeInMillis) {
        try {
            super.setTimeout(key, maxIdleTimeInMillis);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    public void touch(SessionKey key) {
        try {
            super.touch(key);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    public String getHost(SessionKey key) {
        try {
            return super.getHost(key);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    public Collection<Object> getAttributeKeys(SessionKey key) {
        try {
            return super.getAttributeKeys(key);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    public Object getAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.getAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    public void setAttribute(SessionKey sessionKey, Object attributeKey, Object value) {
        try {
            super.setAttribute(sessionKey, attributeKey, value);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    public Object removeAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.removeAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    public void stop(SessionKey key) {
        try {
            super.stop(key);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    public void checkValid(SessionKey key) {
        try {
            super.checkValid(key);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    protected Session doCreateSession(SessionContext context) {
        try {
            return super.doCreateSession(context);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    protected Session newSessionInstance(SessionContext context) {
        Session session = super.newSessionInstance(context);
        session.setTimeout(this.getGlobalSessionTimeout());
        return session;
    }

    public Session start(SessionContext context) {
        try {
            return super.start(context);
        }
        catch (NullPointerException e) {
            SimpleSession session = new SimpleSession();
            session.setId((Serializable)Integer.valueOf(0));
            return session;
        }
    }
}

