/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.service;

import com.crawler.waqf.common.persistence.BaseEntity;
import com.crawler.waqf.common.persistence.CrudDao;
import com.crawler.waqf.common.persistence.DataEntity;
import com.crawler.waqf.common.persistence.Page;
import com.crawler.waqf.common.service.BaseService;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class CrudService<D extends CrudDao<T>, T extends DataEntity<T>>
extends BaseService {
    @Autowired
    protected D dao;

    public T get(String id) {
        return (T)((DataEntity)((Object)this.dao.get((String)id)));
    }

    public T get(T entity) {
        return (T)((DataEntity)this.dao.get(entity));
    }

    public List<T> findList(T entity) {
        return this.dao.findList(entity);
    }

    public Page<T> findPage(Page<T> page, T entity) {
        ((BaseEntity)entity).setPage(page);
        page.setList(this.dao.findList(entity));
        return page;
    }

    @Transactional(readOnly=false)
    public void save(T entity) {
        if (((BaseEntity)entity).getIsNewRecord()) {
            ((DataEntity)entity).preInsert();
            this.dao.insert(entity);
        } else {
            ((DataEntity)entity).preUpdate();
            this.dao.update(entity);
        }
    }

    @Transactional(readOnly=false)
    public void delete(T entity) {
        this.dao.delete(entity);
    }

    @Transactional(readOnly=false)
    public void deleteByLogic(T entity) {
        this.dao.deleteByLogic(entity);
    }

    @Transactional(readOnly=false)
    public void deleteAll(Collection<T> entitys) {
        for (DataEntity entity : entitys) {
            this.dao.delete((DataEntity)entity);
        }
    }

    public T findUniqueByProperty(String propertyName, Object value) {
        return (T)((DataEntity)this.dao.findUniqueByProperty(propertyName, value));
    }
}

