/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.tag;

import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.utils.SpringContextHolder;
import com.crawler.waqf.modules.sys.entity.Menu;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class MenuTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    protected Menu menu;

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public int doStartTag() throws JspTagException {
        return 6;
    }

    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            String menu = (String)this.pageContext.getSession().getAttribute("menu");
            if (menu != null) {
                out.print(menu);
            } else {
                menu = this.end().toString();
                out.print(menu);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 6;
    }

    public StringBuffer end() {
        StringBuffer sb = new StringBuffer();
        sb.append(MenuTag.getChildOfTree(this.menu, 0, UserUtils.getMenuList()));
        return sb;
    }

    private static String getChildOfTree(Menu parent, int level, List<Menu> menuList) {
        StringBuffer menuString = new StringBuffer();
        String href = "";
        if (!parent.hasPermisson()) {
            return "";
        }
        if (level > 0) {
            menuString.append("<li data-id=\"" + parent.getId() + "\">");
            ServletContext context = SpringContextHolder.getBean(ServletContext.class);
            if (parent.getHref() != null && parent.getHref().length() > 0) {
                href = parent.getHref().startsWith("http://") ? parent.getHref() : (parent.getHref().endsWith(".html") && !parent.getHref().endsWith("ckfinder.html") ? context.getContextPath() + parent.getHref() : context.getContextPath() + Global.getAdminPath() + parent.getHref());
            }
        }
        if ((parent.getHref() == null || parent.getHref().trim().equals("")) && parent.getIsShow().equals("1")) {
            if (level > 0) {
                menuString.append("<a href=\"" + href + "\"><i class=\"fa " + parent.getIcon() + "\"></i> <span class=\"nav-label\">" + parent.getName() + "</span><span class=\"fa arrow\"></span></a>");
            }
            if (level == 1) {
                menuString.append("<ul class=\"nav nav-second-level\">");
            } else if (level == 2) {
                menuString.append("<ul class=\"nav nav-third-level\">");
            } else if (level == 3) {
                menuString.append("<ul class=\"nav nav-forth-level\">");
            } else if (level == 4) {
                menuString.append("<ul class=\"nav nav-fifth-level\">");
            }
            for (Menu child : menuList) {
                if (!child.getParentId().equals(parent.getId()) || !child.getIsShow().equals("1")) continue;
                menuString.append(MenuTag.getChildOfTree(child, level + 1, menuList));
            }
            if (level > 0) {
                menuString.append("</ul>");
            }
        } else {
            menuString.append("<a class=\"J_menuItem\"  href=\"" + href + "\" ><i class=\"fa " + parent.getIcon() + "\"></i> <span class=\"nav-label\">" + parent.getName() + "</span></a>");
        }
        if (level > 0) {
            menuString.append("</li>");
        }
        return menuString.toString();
    }
}

