/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.entity;

import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.persistence.DataEntity;
import com.crawler.waqf.common.utils.Collections3;
import com.crawler.waqf.common.utils.excel.annotation.ExcelField;
import com.crawler.waqf.common.utils.excel.fieldtype.RoleListType;
import com.crawler.waqf.modules.sys.entity.Role;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;

public class User
extends DataEntity<User> {
    private static final long serialVersionUID = 1L;
    private String loginName;
    private String password;
    private String name;
    private String email;
    private String phone;
    private String userType;
    private String loginIp;
    private Date loginDate;
    private Integer locked;
    private String avatar;
    private String oldLoginName;
    private String newPassword;
    private String oldLoginIp;
    private Date oldLoginDate;
    private Role role;
    private List<Role> roleList = Lists.newArrayList();

    public User() {
        this.locked = Global.DISABLE;
    }

    public User(String id) {
        super(id);
    }

    public User(String id, String loginName) {
        super(id);
        this.loginName = loginName;
    }

    public User(Role role) {
        this.role = role;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Integer getLocked() {
        return this.locked;
    }

    public void setLocked(Integer locked) {
        this.locked = locked;
    }

    @Override
    @ExcelField(title="ID", type=1, align=2, sort=1)
    public String getId() {
        return this.id;
    }

    @Length(min=1, max=100, message="\u767b\u5f55\u540d\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    @ExcelField(title="\u767b\u5f55\u540d", align=2, sort=30)
    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    @JsonIgnore
    @Length(min=1, max=100, message="\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Length(min=1, max=100, message="\u59d3\u540d\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    @ExcelField(title="\u59d3\u540d", align=2, sort=40)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Email(message="\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e")
    @Length(min=0, max=200, message="\u90ae\u7bb1\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 200 \u4e4b\u95f4")
    @ExcelField(title="\u90ae\u7bb1", align=1, sort=50)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Length(min=0, max=200, message="\u7535\u8bdd\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 200 \u4e4b\u95f4")
    @ExcelField(title="\u7535\u8bdd", align=2, sort=60)
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Length(min=0, max=100, message="\u7528\u6237\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e 1 \u548c 100 \u4e4b\u95f4")
    @ExcelField(title="\u7528\u6237\u7c7b\u578b", align=2, sort=80, dictType="sys_user_type")
    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Override
    @ExcelField(title="\u521b\u5efa\u65f6\u95f4", type=0, align=1, sort=90)
    public Date getCreateDate() {
        return this.createDate;
    }

    @ExcelField(title="\u6700\u540e\u767b\u5f55IP", type=1, align=1, sort=100)
    public String getLoginIp() {
        return this.loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ExcelField(title="\u6700\u540e\u767b\u5f55\u65e5\u671f", type=1, align=1, sort=110)
    public Date getLoginDate() {
        return this.loginDate;
    }

    public void setLoginDate(Date loginDate) {
        this.loginDate = loginDate;
    }

    public String getOldLoginName() {
        return this.oldLoginName;
    }

    public void setOldLoginName(String oldLoginName) {
        this.oldLoginName = oldLoginName;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getOldLoginIp() {
        if (this.oldLoginIp == null) {
            return this.loginIp;
        }
        return this.oldLoginIp;
    }

    public void setOldLoginIp(String oldLoginIp) {
        this.oldLoginIp = oldLoginIp;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public Date getOldLoginDate() {
        if (this.oldLoginDate == null) {
            return this.loginDate;
        }
        return this.oldLoginDate;
    }

    public void setOldLoginDate(Date oldLoginDate) {
        this.oldLoginDate = oldLoginDate;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @JsonIgnore
    @ExcelField(title="\u62e5\u6709\u89d2\u8272", align=1, sort=800, fieldType=RoleListType.class)
    public List<Role> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<Role> roleList) {
        this.roleList = roleList;
    }

    @JsonIgnore
    public List<String> getRoleIdList() {
        ArrayList roleIdList = Lists.newArrayList();
        for (Role role : this.roleList) {
            roleIdList.add(role.getId());
        }
        return roleIdList;
    }

    public void setRoleIdList(List<String> roleIdList) {
        this.roleList = Lists.newArrayList();
        for (String roleId : roleIdList) {
            Role role = new Role();
            role.setId(roleId);
            this.roleList.add(role);
        }
    }

    public String getRoleNames() {
        return Collections3.extractToString(this.roleList, "name", ",");
    }

    public boolean isDeveloper() {
        return User.isDeveloper(this.id);
    }

    public static boolean isDeveloper(String id) {
        return id != null && "-1".equals(id);
    }

    public boolean isAdmin() {
        return User.isAdmin(this.id);
    }

    public static boolean isAdmin(String id) {
        return id != null && "1".equals(id);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

