/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.security;

import com.crawler.waqf.common.json.AjaxJson;
import com.crawler.waqf.common.json.PrintJSON;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.modules.sys.security.SystemAuthorizingRealm;
import com.crawler.waqf.modules.sys.security.UsernamePasswordToken;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.stereotype.Service;

@Service
public class FormAuthenticationFilter
extends org.apache.shiro.web.filter.authc.FormAuthenticationFilter {
    public static final String DEFAULT_CAPTCHA_PARAM = "validateCode";
    public static final String DEFAULT_MOBILE_PARAM = "mobileLogin";
    public static final String DEFAULT_MESSAGE_PARAM = "message";
    private String captchaParam = "validateCode";
    private String mobileLoginParam = "mobileLogin";
    private String messageParam = "message";

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        if (password == null) {
            password = "";
        }
        boolean rememberMe = this.isRememberMe(request);
        String host = StringUtils.getRemoteAddr((HttpServletRequest)request);
        String captcha = this.getCaptcha(request);
        boolean mobile = this.isMobileLogin(request);
        return new UsernamePasswordToken(username, password.toCharArray(), rememberMe, host, captcha, mobile);
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    public String getMobileLoginParam() {
        return this.mobileLoginParam;
    }

    protected boolean isMobileLogin(ServletRequest request) {
        return WebUtils.isTrue((ServletRequest)request, (String)this.getMobileLoginParam());
    }

    public String getMessageParam() {
        return this.messageParam;
    }

    public String getSuccessUrl() {
        return super.getSuccessUrl();
    }

    protected void issueSuccessRedirect(ServletRequest request, ServletResponse response) throws Exception {
        SystemAuthorizingRealm.Principal p = UserUtils.getPrincipal();
        if (p != null && !p.isMobileLogin()) {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.getSuccessUrl(), null, (boolean)true);
        } else {
            AjaxJson j = new AjaxJson();
            j.setSuccess(true);
            j.setMsg("\u767b\u5f55\u6210\u529f!");
            j.put("username", p.getLoginName());
            j.put("name", p.getName());
            j.put(DEFAULT_MOBILE_PARAM, p.isMobileLogin());
            j.put("JSESSIONID", p.getSessionid());
            PrintJSON.write((HttpServletResponse)response, j.getJsonStr());
        }
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        String className = e.getClass().getName();
        String message = "";
        if (IncorrectCredentialsException.class.getName().equals(className) || UnknownAccountException.class.getName().equals(className)) {
            message = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.";
        } else if (e.getMessage() != null && StringUtils.startsWith((CharSequence)e.getMessage(), (CharSequence)"msg:")) {
            message = StringUtils.replace((String)e.getMessage(), (String)"msg:", (String)"");
        } else {
            message = "\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
            e.printStackTrace();
        }
        request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
        request.setAttribute(this.getMessageParam(), (Object)message);
        return true;
    }
}

