/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.service;

import com.crawler.waqf.common.bean.Node;
import com.crawler.waqf.common.bean.TreeNode;
import com.crawler.waqf.common.service.TreeService;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.common.utils.TreeNodeUtils;
import com.crawler.waqf.modules.sys.dao.AreaDao;
import com.crawler.waqf.modules.sys.entity.Area;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@Transactional(readOnly=true)
public class AreaService
extends TreeService<AreaDao, Area> {
    public List<Area> findAll() {
        return UserUtils.getAreaList();
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Area area) {
        super.save(area);
        UserUtils.removeCache("areaList");
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Area area) {
        super.delete(area);
        UserUtils.removeCache("areaList");
    }

    public List<TreeNode> tree(@RequestParam(required=false) String extId) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List<Area> list = this.findAll();
        String rootId = "86";
        for (int i = 0; i < list.size(); ++i) {
            Area e = list.get(i);
            if (rootId.equals(e.getId()) || !StringUtils.isBlank((CharSequence)extId) && (extId == null || extId.equals(e.getId()) || e.getParentIds().indexOf("," + extId + ",") != -1)) continue;
            Node node = new Node();
            node.setId(e.getId());
            node.setParentId(e.getParentId());
            node.setLabel(e.getName());
            nodes.add(node);
        }
        return TreeNodeUtils.generateTree(nodes, rootId);
    }
}

