/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.thread;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.thread.PropertiesUtil;
import org.apache.log4j.Logger;
import org.mybatis.spring.SqlSessionFactoryBean;

public class Runnable
implements java.lang.Runnable {
    public static Logger log = Logger.getLogger(Runnable.class);
    private String location;
    private Configuration configuration;
    private Long beforeTime = 0L;
    private static boolean refresh = false;
    private static String mappingPath = "mappings";
    private static int delaySeconds = 10;
    private static int sleepSeconds = 1;
    private static boolean enabled = false;

    public static boolean isRefresh() {
        return refresh;
    }

    public Runnable(String location, Configuration configuration) {
        this.location = location.replaceAll("\\\\", "/");
        this.configuration = configuration;
    }

    @Override
    public void run() {
        this.location = this.location.substring("file [".length(), this.location.lastIndexOf(mappingPath) + mappingPath.length());
        this.beforeTime = System.currentTimeMillis();
        log.debug((Object)("[location] " + this.location));
        log.debug((Object)("[configuration] " + this.configuration));
        if (enabled) {
            this.start(this);
        }
    }

    public void start(final Runnable runnable) {
        new Thread(new java.lang.Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delaySeconds * 1000);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                refresh = true;
                System.out.println("========= Enabled refresh mybatis mapper =========");
                while (true) {
                    try {
                        runnable.refresh(Runnable.this.location, Runnable.this.beforeTime);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    try {
                        Thread.sleep(sleepSeconds * 1000);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public void refresh(String filePath, Long beforeTime) throws Exception {
        Long refrehTime = System.currentTimeMillis();
        List<File> refreshs = this.getRefreshFile(new File(filePath), beforeTime);
        if (refreshs.size() > 0) {
            log.debug((Object)("refresh files:" + refreshs.size()));
        }
        for (int i = 0; i < refreshs.size(); ++i) {
            System.out.println("Refresh file: " + mappingPath + StringUtils.substringAfterLast((String)refreshs.get(i).getAbsolutePath(), (String)mappingPath));
            log.debug((Object)("refresh file:" + refreshs.get(i).getAbsolutePath()));
            log.debug((Object)("refresh filename:" + refreshs.get(i).getName()));
            SqlSessionFactoryBean.refresh(new FileInputStream(refreshs.get(i)), refreshs.get(i).getAbsolutePath(), this.configuration);
        }
        if (refreshs.size() > 0) {
            this.beforeTime = refrehTime;
        }
    }

    public List<File> getRefreshFile(File dir, Long beforeTime) {
        ArrayList<File> refreshs = new ArrayList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                refreshs.addAll(this.getRefreshFile(file, beforeTime));
                continue;
            }
            if (file.isFile()) {
                if (!this.check(file, beforeTime)) continue;
                refreshs.add(file);
                continue;
            }
            System.out.println("error file." + file.getName());
        }
        return refreshs;
    }

    public boolean check(File file, Long beforeTime) {
        return file.lastModified() > beforeTime;
    }

    static {
        delaySeconds = PropertiesUtil.getInt("delaySeconds");
        sleepSeconds = PropertiesUtil.getInt("sleepSeconds");
        mappingPath = PropertiesUtil.getString("mappingPath");
        enabled = "true".equals(PropertiesUtil.getString("enabled"));
        delaySeconds = delaySeconds == 0 ? 50 : delaySeconds;
        sleepSeconds = sleepSeconds == 0 ? 1 : sleepSeconds;
        mappingPath = StringUtils.isBlank((CharSequence)mappingPath) ? "mappings" : mappingPath;
        log.debug((Object)("[delaySeconds] " + delaySeconds));
        log.debug((Object)("[sleepSeconds] " + sleepSeconds));
        log.debug((Object)("[mappingPath] " + mappingPath));
    }
}

