package com.crawler.client;

import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

import com.crawler.client.exception.ErrorMessage;
import com.crawler.waf.exceptions.extendExceptions.CustomExceptionSupport;

import java.net.URI;

/**
 * 标识访问远程服务器提供 RESTful api 资源过程中产生异常
 */
public class ResourceAccessException extends RuntimeException implements CustomExceptionSupport{

    /** serialVersionUID*/
	private static final long serialVersionUID = 8905820435703258732L;
	
	private ResponseEntity<ErrorMessage> responseEntity;
    private URI uri;
    private HttpMethod httpMethod;

    /**
     * 构造包含一个远程服务器的错误响应的异常对象
     * @param responseEntity
     * @param httpMethod
     * @param uri
     */
    public ResourceAccessException(ResponseEntity<ErrorMessage> responseEntity, HttpMethod httpMethod, URI uri)
    {
        super(responseEntity.getBody().getMessage());
    	this.responseEntity = responseEntity;
        this.httpMethod = httpMethod;
        this.uri = uri;
    }

    public URI getUri() {
        return uri;
    }

    public HttpMethod getHttpMethod() {
        return httpMethod;
    }

    /**
     * 获取个
     * @return 远程服务器响应的异常对象
     */
    public ResponseEntity<ErrorMessage> getResponseEntity() {
        return responseEntity;
    }
}
