package com.crawler.waf.exceptions.handlers;

import javax.servlet.http.HttpServletRequest;

import org.springframework.http.HttpStatus;

import com.crawler.waf.exceptions.handlers.AbstractWafExceptionHandler;
import com.crawler.waf.exceptions.extendExceptions.ExceptionSupport;
import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import com.crawler.waf.exceptions.messages.ErrorMessage;
import com.crawler.waf.exceptions.providers.ErrorMessageProvider;
import com.crawler.waf.exceptions.providers.CustomErrorMessageProvider;
/**
 * WAF自定义的异常捕获器
 *
 */
public class CustomExceptionHandler extends AbstractWafExceptionHandler {

	/**
	 * 构建自定义异常的捕获器
	 * @param exceptionClass 异常类型
	 * @param status         http响应码
	 * @param provider       异常处理器
	 */
	public CustomExceptionHandler(Class<?> exceptionClass,
			HttpStatus status, ErrorMessageProvider provider) {
		 
		super(exceptionClass, status, new CustomErrorMessageProvider());
	}

	public CustomExceptionHandler(Class<?> exceptionClass, HttpStatus status) {
		super(exceptionClass, status, new CustomErrorMessageProvider());
	}

	public CustomExceptionHandler(Class<?> exceptionClass) {
		super(exceptionClass, HttpStatus.INTERNAL_SERVER_ERROR, new CustomErrorMessageProvider());
	}

	public CustomExceptionHandler(HttpStatus status) {
		super(status);
	}

	@Override
	public Object createBody(Exception ex, HttpServletRequest req) {
		
		if(ExceptionSupport.class.isInstance(ex)){
			ErrorMessage em = ((ExceptionSupport)ex).getErrorMessage();
			super.getProvider().handleServerInfo(em, req);
			return em;
		}else{
			throw new WafSimpleException("exception mapper error");
		}
	}

}
