package com.crawler.waf.exceptions.handlers;

import com.crawler.waf.exceptions.messages.ErrorMessage;
import com.crawler.waf.exceptions.support.ArrayQueue;


public class ErrorMessageQueueHandler {
		
	private static int capacity = 100;
	
	private static ArrayQueue<ErrorMessage> errorMessagesQueue = new ArrayQueue<ErrorMessage>(capacity, true);
	
	/**
	 * 
	* @Title: setMaxEntries 
	* @Description: 重置容器的长度
	* @param @param maxEntries    设定文件 
	* @return void    返回类型 
	* @throws
	 */
	public static void setCapacity(int capacity){
		errorMessagesQueue.copyArray(capacity);
	}
	
	/**
	* @Title: add 
	* @Description: 存放异常信息
	* @param @param errorMessage    设定文件 
	* @return void    返回类型 
	* @throws
	 */
	public static void add(ErrorMessage errorMessage){
		ErrorMessage errorMessageInfo = new ErrorMessage(); 
		errorMessageInfo.setCode(errorMessage.getCode());
		errorMessageInfo.setHostId(errorMessage.getHostId());
		errorMessageInfo.setServerTime(errorMessage.getServerTime());
		errorMessageInfo.setType(errorMessage.getType());
		errorMessageInfo.setRequestId(errorMessage.getRequestId());
		errorMessageInfo.setMessage(errorMessage.getMessage());
		errorMessageInfo.setStackTrace(errorMessage.getStackTrace());
		errorMessagesQueue.add(errorMessageInfo);
	}
	
	/**
	 * 
	* @Title: getReleasedExeQueuep 
	* @Description: 获取所有异常信息 
	* @param @return    设定文件 
	* @return BlockingQueue<ErrorMessage>    返回类型 
	* @throws
	 */
	public static ErrorMessage[] getReleasedExceptionQueue() {
		ErrorMessage [] errorMessages = errorMessagesQueue.toArray(ErrorMessage.class);
		return errorMessages;
	}
	
	/**
	 * 
	* @Title: getReleasedExe 
	* @Description: 根据requestId查询异常信息 
	* @param @param requestId
	* @param @return    设定文件 
	* @return String    返回类型 
	* @throws
	 */
	public static ErrorMessage getReleasedException(String requestId){
		ErrorMessage resErrorMessage = null;
		ErrorMessage [] errorMessages = getReleasedExceptionQueue();
		if(errorMessages!=null && errorMessages.length>0){
			for (int i = 0; i < errorMessages.length; i++) {
				ErrorMessage errorMessage = errorMessages[i];
				if (errorMessage.getRequestId().equals(requestId)) {
					resErrorMessage = errorMessage;
					break;
				}
			}
		}
		return resErrorMessage;
	}
	
}
