package com.crawler.waf.exceptions.providers;

import java.util.Date;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import com.crawler.waf.exceptions.providers.ErrorMessageProvider;
import com.crawler.waf.exceptions.messages.ErrorMessage;
/**
 * 当前自定义错误消息的处理类，暂时没有更加具体的实现。
 *
 */
public class CustomErrorMessageProvider
		implements ErrorMessageProvider {

	@Override
	public ErrorMessage handleMessage() {
		
		return new ErrorMessage();
	}

	@Override
	public void handleServerInfo(ErrorMessage em, HttpServletRequest request) {
		em.setHostId(request.getServerName());
        em.setRequestId(UUID.randomUUID().toString());
        em.setServerTime(new Date());
	}

}
