package com.crawler.waf.exceptions.providers;


import javax.servlet.http.HttpServletRequest;

import com.crawler.waf.exceptions.messages.ErrorMessage;
/**
 * 定义异常数据处理的provider接口。<br>
 * 主要提供对消息体，响应码的扩展
 *
 */
public interface ErrorMessageProvider {

	/**
	 * 处理消息体
	 * @return
	 */
	public ErrorMessage handleMessage();
	
	/**
	 * 扩展实现针对服务器端的信息，封装在ErrorMessage中。包括:<br>
	 * realm，hostId，requestId，serverTime
	 * @param em
	 */
	public void handleServerInfo(ErrorMessage em,HttpServletRequest request);
}
