package com.crawler.waqf.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.alibaba.fastjson.JSONObject;

import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;


/**
 * HttpServletRequest 工具
 * @author George
 *
 * 2018年4月26日 上午9:26:22
 */
public class RequestUtils {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);
	
	/**
	 * 获取请求表单参数
	 * @param request
	 * @return
	 */
	public static SortedMap<String, String> getFormData(HttpServletRequest request){
		SortedMap<String, String> map = new TreeMap<String, String>();
        Enumeration<String> e = request.getParameterNames();  
        while(e.hasMoreElements()){  
           String name = e.nextElement();  
           String value =  request.getParameter(name);
           map.put(name, value);
        }
        return map;
	}
	
	/**
	 * 获取请求体内容
	 * @param request
	 * @return
	 */
	public static SortedMap<String, String> getBody(HttpServletRequest request){
		SortedMap<String, String> map = new TreeMap<String, String>();
		try {
			BufferedReader br = request.getReader();
			String str, content = "";
			while((str = br.readLine()) != null){
				content += str;
			}
			System.out.println("请求体内容：" + content);
			if(content!= null && content.startsWith("{") && content.endsWith("}")) {
				JSONObject jsonObject = JSONObject.parseObject(content);
				for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
					Object obj = entry.getValue();
					map.put(entry.getKey(), obj == null ? null: String.valueOf(obj));
				}
			}
	        
		}
		catch(IOException ex) {
			LOGGER.error(ex.getMessage(), ex);
		}
		return map;
	}
	
	/**
	 * 获取数据
	 * @param request
	 * @return
	 */
	public static SortedMap<String, String> getData(HttpServletRequest request) {
		SortedMap<String, String> map = getFormData(request);
		if(map.size() == 0) {
			map = getBody(request);
			System.out.println("BODY:" + BeanUtils.toJSONString(map));
		}
		return map;
	}

	
	/**
	 * 获取 HttpServletRequest
	 * @return
	 */
	public static HttpServletRequest getRequest(){
		RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
		if(requestAttributes == null) {
			return null;
		}
		return ((ServletRequestAttributes)requestAttributes).getRequest();
		 
	}
	
	/**
	 * 获取 ServletRequestAttributes
	 * @return
	 */
	public static ServletRequestAttributes requestAttributes(){
		RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
		if(requestAttributes == null) {
			return null;
		}
		return  ((ServletRequestAttributes)requestAttributes);
	}
	
	
	/**
     * 判断请求是否手机端
     * @param req
     * @return
     */
    public static boolean isMobile(HttpServletRequest request) {
        UserAgent ua = UserAgent.parseUserAgentString(request.getHeader("User-Agent"));
        OperatingSystem os = ua.getOperatingSystem();
        if(DeviceType.MOBILE.equals(os.getDeviceType())) {
            return true;
        }
        return false;
    }


}