package com.crawler.waf.exceptions;

import java.util.Map;
/**
 * Map集合对象的数据合并操作
 *
 */
abstract class MapUtils {

    /**
     * 实现源map集合到目标map集合的诗句拷贝处理，对于已有的key不做覆盖
     * @param target
     * @param source
     */
    static <K, V> void putAllIfAbsent(Map<K, V> target, Map<K, V> source) {

        for (Map.Entry<K, V> entry : source.entrySet()) {
            if (!target.containsKey(entry.getKey())) {
                target.put(entry.getKey(), entry.getValue());
            }
        }
    }
}
