package com.crawler.waf.exceptions.messages;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.crawler.waf.exceptions.messages.ErrorMessage;
import com.crawler.waf.exceptions.messages.ValidationErrorMessage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
/**
 * 封装错WAF请求的错误信息，按照前期的设计结构，对错误内容进行结构化分装。在通用错误的基础上扩展验证性错误，验证性错误中包含验证的细节错误内容。
 *
 */
@JsonInclude(Include.NON_EMPTY)
public class ValidationErrorMessage extends ErrorMessage {

    public ValidationErrorMessage(String code, String message, String hostId, String requestId, Date serverTime, URI type,List<Error> errors) {
		super(code, message, hostId, requestId, serverTime, type);
		this.errors = errors;
	}

    

	public List<Error> getErrors() {
		return errors;
	}

	public void setErrors(List<Error> errors) {
		this.errors = errors;
	}



	private static final long serialVersionUID = 1L;

    private List<Error> errors = new ArrayList<>(6);



    public ValidationErrorMessage addError(String field, Object rejectedValue, String message) {
        Error error = new Error();
        error.setField(field);
        error.setMessage(message);
        error.setRejected(rejectedValue);

        errors.add(error);
        return this;
    }

    public ValidationErrorMessage addError(String message) {
        Error error = new Error();
        error.setMessage(message);
        errors.add(error);
        return this;
    }


    @JsonInclude(NON_EMPTY)
    static class Error {
        private String field;
        private Object rejected;
        private String message;
		public String getField() {
			return field;
		}
		public void setField(String field) {
			this.field = field;
		}
		public Object getRejected() {
			return rejected;
		}
		public void setRejected(Object rejected) {
			this.rejected = rejected;
		}
		public String getMessage() {
			return message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
        
        
    }
}
