package com.crawler.waf.exceptions.providers;

import java.util.Date;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import com.crawler.waf.exceptions.providers.ErrorMessageProvider;
import com.crawler.waf.exceptions.messages.ErrorMessage;

/**
 * 默认的WAF异常消息处理的提供器<br>
 * 此默认的异常消息处理提供器，主要处理服务器内部错误。所返回的错误码统一为500<br>
 * 其捕获的信息全部为内部异常{jre定义的异常类，spring等框架定义异常类等等}<br>
 * 异常信息的编码为：WAF/INTERNAL_SERVER_ERROR<br>
 * 异常信息内容为：系统异常自带的信息内容

 *
 */
public class DefaultErrorMessageProvider  implements
		ErrorMessageProvider {
	
	private ErrorMessage em;

	@Override
	public ErrorMessage handleMessage() {
		em = new ErrorMessage("WAF/INTERNAL_SERVER_ERROR");
		return em;
	}

	@Override
	public void handleServerInfo(ErrorMessage em,HttpServletRequest request) {
		em.setHostId(request.getServerName());
        em.setRequestId(UUID.randomUUID().toString());
        em.setServerTime(new Date());
	}

}
