package com.crawler.waf.security.authens;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 通过Mac进行验证有效性，返回验证的结果封装
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlRootElement
public class OauthAccessToken implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5737546567777696640L;
	/**
	 * 认证后的用户id
	 */
	private String userId;
	/**
	 * 验证后的token
	 */
	private String accessToken;
	/**
	 * 过期刷新用的token
	 */
	private String refreshToken;

	/**
	 * 过期时间
	 */
	private Date expiresAt;
	/**
	 * 服务器返回时间
	 */
	private Date serverTime;
	/**
	 * hmac 的密钥
	 */
	private String macKey;

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	public Date getExpiresAt() {
		return expiresAt;
	}

	public void setExpiresAt(Date expiresAt) {
		this.expiresAt = expiresAt;
	}

	public Date getServerTime() {
		return serverTime;
	}

	public void setServerTime(Date serverTime) {
		this.serverTime = serverTime;
	}

	/**
	 * 服务器端通信安全验证的token
	 */
	@JsonIgnore
	public String getBearerToken() {
		return accessToken;
	}

	public String getMacKey() {
		return macKey;
	}

	public void setMacKey(String macKey) {
		this.macKey = macKey;
	}

	public String getRefreshToken() {
		return refreshToken;
	}

	public void setRefreshToken(String refreshToken) {
		this.refreshToken = refreshToken;
	}

}
