package com.crawler.waqf.common.utils;

import java.io.Serializable;

/**
 * ID工具类
 * @author Rubekid
 *
 * 2017年4月13日 下午2:52:49
 */
public class IdUtils {

	/**
	 * 判断是否为空
	 * @param id
	 * @param filterValues
	 * @return
	 */
	public static boolean isBlank(Serializable id, String ... filterValues){
		if(id == null){
			return true;
		}
		String str = String.valueOf(id);
		if("".equals(str)){
			return true;
		}
		for(String value : filterValues){
			if(value.equals(str)){
				return true;
			}
		}
		return false;
	}
	
	/**
	 * 非空
	 * @param id
	 * @param filterValues
	 * @return
	 */
	public static boolean isNotBlank(Serializable id, String ... filterValues){
		return !isBlank(id, filterValues);
	}
}
