package com.crawler.waqf.modules.sys.dao;

import com.crawler.waqf.common.persistence.CrudDao;
import com.crawler.waqf.common.persistence.annotation.MyBatisDao;
import com.crawler.waqf.modules.sys.entity.Role;

/**
 * 角色DAO接口
 * 
 * @version 2013-12-05
 */
@MyBatisDao
public interface RoleDao extends CrudDao<Role> {

	/**
	 * 根据名称获取角色
	 * @param role
	 * @return
	 */
	public Role getByName(Role role);
	
	/**
	 * 根据英文名称获取角色
	 * @param role
	 * @return
	 */
	public Role getByEnname(Role role);

	/**
	 * 维护角色与菜单权限关系
	 * @param role
	 * @return
	 */
	public int deleteRoleMenu(Role role);

	/**
	 * 添加角色菜单
	 * @param role
	 * @return
	 */
	public int insertRoleMenu(Role role);
}
