package com.crawler.waqf.modules.sys.service;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

import com.crawler.waqf.common.bean.Node;
import com.crawler.waqf.common.bean.TreeNode;
import com.crawler.waqf.common.service.TreeService;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.common.utils.TreeNodeUtils;
import com.crawler.waqf.modules.sys.dao.AreaDao;
import com.crawler.waqf.modules.sys.entity.Area;
import com.crawler.waqf.modules.sys.utils.UserUtils;

/**
 * 区域Service
 * 
 * @version 2014-05-16
 */
@Service
@Transactional(readOnly = true)
public class AreaService extends TreeService<AreaDao, Area> {
	
	@Resource
	private AreaDao areaDao;

	public List<Area> findAll(){
		return UserUtils.getAreaList();
	}

	@Transactional(readOnly = false)
	public void save(Area area) {
		super.save(area);
		UserUtils.removeCache(UserUtils.CACHE_AREA_LIST);
	}
	
	@Transactional(readOnly = false)
	public void delete(Area area) {
		super.delete(area);
		UserUtils.removeCache(UserUtils.CACHE_AREA_LIST);
	}
	
	/**
	 * 获取区域树状数据
	 * @param extId
	 * @return
	 */
	public List<TreeNode> tree(@RequestParam(required=false) String extId) {
		List<Node> nodes = new ArrayList<Node>();
		List<Area> list = this.findAll();
		String rootId = "86";
		for (int i=0; i<list.size(); i++){
			Area e = list.get(i);
			if(rootId.equals(e.getId())){
				continue;
			}
			if (StringUtils.isBlank(extId) || (extId!=null && !extId.equals(e.getId()) && e.getParentIds().indexOf(","+extId+",")==-1)){
				Node node = new Node();
				node.setId(e.getId());
				node.setParentId(e.getParentId());
				node.setLabel(e.getName());
				nodes.add(node);
			}
		}
		return TreeNodeUtils.generateTree(nodes, rootId);
	}
	
	/**
	 * 根据城市市获取城市信息
	 * @param city
	 * @return
	 */
	public Area findCity(String city){
		return areaDao.findCity(city);
	}
	
	/**
	 * 获取省份
	 * @param province
	 * @return
	 */
	public Area findProvince(String province){
		return areaDao.findProvince(province);
	}
	
}
