package com.crawler.client.auth;

import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

import com.crawler.client.entity.BearerToken;
import com.crawler.waf.config.WafProperties;

/**
 * token服务提供类
 */
public class BearerTokenProvider {
	private static final Logger LOGGER = LoggerFactory.getLogger(BearerTokenProvider.class);
    public static final String CLIENT_MIN_REFRESH_SPAN = "client.minRefreshSpan";
    private static final String CLIENT_MIN_REFRESH_SPAN_VALUE = "300000";

    private BearerToken bearerToken;
    private int minRefreshSpan;

    private BearerTokenService bearerTokenService;

    public BearerTokenProvider(BearerTokenService bearerTokenService) {
        this.bearerTokenService = bearerTokenService;
        minRefreshSpan = WafProperties.getPropertyForInteger(CLIENT_MIN_REFRESH_SPAN, CLIENT_MIN_REFRESH_SPAN_VALUE);
    }

    public BearerToken getToken() {
        if (bearerToken == null) {
            synchronized (this) {
                bearerToken = bearerTokenService.getBearerToken();
            }
        }
        Assert.notNull(bearerToken, "bearerToken");
        if (shouldRefreshToken(bearerToken)) {
            synchronized (this) {
            	try{
            		bearerToken = bearerTokenService.refreshBearerToken(bearerToken);
            		System.out.println("刷新BearerToken成功");
            	}
            	catch(Exception ex){
            		//重置
            		bearerToken = null;
            		LOGGER.error("刷新BearerToken失败：" + ex.getMessage());
            	}
                
            }
            if(bearerToken == null){
            	synchronized (this) {
            		System.out.println("重新获取BearerToken成功");
                    bearerToken = bearerTokenService.getBearerToken();
                }
            }
        }
        return bearerToken;
    }

    public void setToken(BearerToken token) {
        Assert.notNull(token, "token");
        synchronized (this) {
            this.bearerToken = token;
        }
    }

    public boolean isAuthorized() {
        return bearerToken != null && !bearerToken.isExpire();
    }

    protected boolean shouldRefreshToken(BearerToken bearerToken) {
        Assert.notNull(bearerToken, "bearerToken");
        Date now = new Date();
        return bearerToken.getExpiresAt().getTime() - now.getTime() < minRefreshSpan;
    }
}
