package com.crawler.client.http;

import org.springframework.http.HttpHeaders;

import com.crawler.client.support.ClientContextHolder;

/**
 * 封装bearer token头验证http请求工具类
 */
public class SecurityHttpClient extends RestHttpClient {
    public static final String AUTHORIZATION = "Authorization";

    public static final String AUTHORIZATION_TYPE_BEARER = "Bearer";

    @Override
    protected HttpHeaders mergerHeaders(HttpHeaders headers) {
        headers = super.mergerHeaders(headers);
        HttpHeaders tempHeaders = new HttpHeaders();
        if (headers != null) {
            tempHeaders.putAll(headers);
        }
        tempHeaders.add(AUTHORIZATION, AUTHORIZATION_TYPE_BEARER + " \""+ ClientContextHolder.getToken().getBearerToken()+"\"");
        return tempHeaders;
    }
}
