package com.crawler.client.http;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

import com.crawler.client.ResourceAccessException;
import com.crawler.client.exception.ErrorMessage;
import com.crawler.client.util.JsonMapper;

import java.io.IOException;

/**
 * 异常处理类
 */
class WafApiErrorHandler extends DefaultResponseErrorHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void handleError(ClientHttpResponse response) throws IOException {
        WafClientHttpResponse wafResponse = (WafClientHttpResponse) response;
        ErrorMessage errorMessage = null;
        HttpHeaders headers = null;
        HttpStatus statusCode;

        String responseText = IOUtils.toString(wafResponse.getBody(), "UTF-8");
        try {
            errorMessage = JsonMapper.parse(responseText, ErrorMessage.class);
            wafResponse.getHeaders();
            statusCode = wafResponse.getStatusCode();
        } catch (IOException ex) {
            String msg = "将 api \"" + wafResponse.getHttpMethod() + " " + wafResponse.getUri() + "\" 的响应内容 \"" + responseText + "\" 转换为 " + ErrorMessage.class.toString() + " 发生异常。";
            log.error(msg, ex);
            throw new IOException(msg, ex);
        }
        log.info("Remote api response error. Response content: ", responseText);
        ResponseEntity<ErrorMessage> responseEntity = new ResponseEntity<ErrorMessage>(errorMessage, headers, statusCode);
        throw new ResourceAccessException(responseEntity, wafResponse.getHttpMethod(), wafResponse.getUri());
    }
}
