package com.crawler.uc.authens;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.io.Serializable;

/**
 * 根据UC中心定义的获取用户信息
 *
 */
public class BaseUserInfo implements Serializable {

	private static final long serialVersionUID = 7891245963510413200L;
	
	/**
	 * 用户ID
	 */
	private Long userId;
	
	/**
	 * 登录帐号
	 */
	private String loginName; 	
	
	/**
	 * 昵称
	 */
	private String nickName;

	/**
	 * 应用ID
	 */
	private String appId;
	
	/**
	 * 签名
	 */
	private String sign;
	
	/**
	 * 头像
	 */
	private String avatar;
	
	/**
	 * 电话号码
	 */
	private String phone;
	
	/**
	 * 性别
	 */
	private Integer gender;
	
	/**
	 * 请求类型，"Mac" or "Bearer"
	 */
	private String userType;
	
	/**
	 * 角色
	 */
	private String role;
	
	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getLoginName() {
		return loginName;
	}

	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}


	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public Integer getGender() {
		return gender;
	}

	public void setGender(Integer gender) {
		this.gender = gender;
	}

	@JsonIgnore
	public String getUserType() {
		return userType;
	}
	
	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getRole() {
		return role;
	}

	public void setRole(String role) {
		this.role = role;
	}
	
}
