package com.crawler.uc.authens;

import java.util.Date;

/**
 * 扩展自GrantAuthority对象，处了获取角色外，封装UC返回的角色相关的信息内容
 */
public class UserRole{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7243022331854420825L;
	/**
	 * 角色信息id
	 */
	private String roleId;
	/**
	 * 角色名称,UC中，角色的名称是小写的英文单词，而且是唯一的，所以在鉴权过程中主要以name为主
	 */
	private String roleName;

	/**
	 * 角色修改时间
	 */
	private Date updateTime;
	/**
	 * 1,--权限扩展 0-NONE,1-READ,2-ADD,3-WRITE,4-DELETE
	 */
	private int authExtra=0;
	
	/**
	 * 返回系统的角色编号
	 */
	public String getAuthority() {
		return this.roleName;
	}

	public String getRoleId() {
		return roleId;
	}

	public void setRoleId(String roleId) {
		this.roleId = roleId;
	}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public int getAuthExtra() {
		return authExtra;
	}

	public void setAuthExtra(int authExtra) {
		this.authExtra = authExtra;
	}


	
}
