package com.crawler.uc.config;

import com.crawler.waf.config.WafProperties;

/**
 * UC常量
 * @author rubekid
 *
 * 2017年9月28日 下午5:37:46
 */
public class UcConstant {

	/**
	 * 是否开启UC服务器
	 */
	public static final boolean UC_ENABLE = WafProperties.getPropertyForBoolean("uc.enable", "false");
	
	/**
	 * 是否支持UC模式
	 */
	public static final boolean SUPPORT_UC = WafProperties.getPropertyForBoolean("uc.support", "false");
	
	/**
	 * 多设备登录
	 */
	public static final boolean MULTI_DEVICE = WafProperties.getPropertyForBoolean("token.multi_device", "false");
	
	/**
	 * 管理员角色 只能单设备登录
	 */
	public static final String ADMIN_ROLES = WafProperties.getProperty("token.role.admin", "ROLE_ADMIN");
	
	/**
	 * 域名替换
	 */
	public static final String HOST_REPLACE = WafProperties.getProperty("token.host_replace", "");

	/**
	 * uc uri名称
	 */
	public static final String UC_URI = "uc.uri";
    
	/**
	 * uc host 名称
	 */
	public static final String UC_HOST = "uc.host";
	
	/**
	 * 推送频道
	 */
	public static final String PUSH_CHANNEL = "UC";
	
	/**
	 * 推送事件 ：强退
	 */
	public static final String PUSH_EVENT_KICK = "kick";
}
