package com.crawler.uc.utils;

import com.crawler.uc.authens.BaseUserInfo;
import com.crawler.uc.exception.AuthenticationException;
import com.crawler.uc.support.WafContext;
import com.crawler.waf.security.authens.OauthAccessToken;


/**
 * UC 工具
 * @author rubekid
 * @date 2016年7月12日
 */
public class UcManager {
	
	/**
	 * 获取当前用户ID
	 * @return
	 */
	public static String getUserId(){
		return getUserId(false);
	}

    /**
     * 获取当前用户ID
     * @return
     */
	public static Long getLongUserId(){
	    return getLongUserId(false);
    }
	
	/**
	 * 获取当前用户id（允许游客）
	 * @return
	 */
	public static String getUserId(boolean anonymous){
		String userId = null;
		try{
			userId = WafContext.getUserId();
		}
		catch(AuthenticationException ex){
			if(anonymous){
				return null;
			}
		}
		if(userId == null && !anonymous){
            throw new AuthenticationException("请登录后操作");
        }
		return userId;
	}

    /**
     * 获取当前用户id（允许游客）
     * @param anonymous
     * @return
     */
	public static Long getLongUserId(boolean anonymous){
	    String userId = getUserId(anonymous);
	    return userId == null ? null : Long.parseLong(userId);
    }
	
	
	public static OauthAccessToken  getUcToken(){
		return WafContext.getCurrentToken(); 
	}
	
	/**
	 * 返回用户信息
	 * @return
	 */
	public static BaseUserInfo getUserInfo(){
		return WafContext.getCurrertUserInfo();
	}
	

}