package com.crawler.waf.exceptions.handlers;

import javax.servlet.http.HttpServletRequest;

import org.springframework.http.ResponseEntity;

/**
 * 捕获异常，并且将异常信息转换成ResponseEntity独享进行输出
 *
 */
public interface ExceptionHandler {

    /**
     * 捕获并且处理生成{@link ResponseEntity}.
     *
     * @param exception 异常类.
     * @param request 当前请求.
     * @return 响应尸体 {@link ResponseEntity}.
     */
    ResponseEntity<?> handleException(Exception exception, HttpServletRequest request);
}
