package com.crawler.waqf.common.enums;

import java.security.InvalidParameterException;

/**
 * 性别
 * @author rubekid
 *
 */
public enum Gender {
	
	SECRET("保密", 0),
	MALE("男", 1),
	FEMALE("女", 2);
	
    /**
     * 名称
     */
    private String name;
    
    /**
     * 值
     */
    private Integer value;  
	
	// 构造方法  
    private Gender(String name, Integer value) {  
        this.name = name;  
        this.value = value;  
    }

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}  
	
	public static Gender parse(Integer value){
		for(Gender gender : values()){
			if(gender.value.equals(value)){
				return gender;
			}
		}
		throw new InvalidParameterException("Invalid value");
	}

}
