package com.crawler.waqf.common.exception;

import org.springframework.http.HttpStatus;

import com.crawler.waf.exceptions.extendExceptions.ExceptionSupport;
import com.crawler.waf.exceptions.messages.ErrorMessage;
/**
 * 标准异常类
 *
 */
@SuppressWarnings("serial")
public class StandedException extends RuntimeException implements ExceptionSupport {

	private ErrorMessage errorMessage;
	private HttpStatus status;
	
	public StandedException(ErrorMessage message,HttpStatus status) {
		super(message.getMessage());
		this.errorMessage = message;
		this.status = status;
	}
	
	@Override
	public ErrorMessage getErrorMessage() {
		return errorMessage;
	}

	@Override
	public HttpStatus getStatus() {
		return status;
	}

}
