/**
 * Copyright &copy; 2015-2020 
 */
package com.crawler.waqf.common.json;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import com.crawler.waqf.common.mapper.JsonMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;


/**
 * $.ajax后需要接受的JSON
 * 
 * @author
 * 
 */
public class AjaxJson {

	private boolean success = true;// 是否成功
	private String errorCode = "-1";//错误代码
	private String msg = "操作成功";// 提示信息
	private LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();//封装json的map
	
	public LinkedHashMap<String, Object> getBody() {
		return body;
	}
	
	/**
	 * 返回错误
	 * @param msg 错误信息
	 * @return
	 */
	public static AjaxJson returnError(String msg){
		AjaxJson ajaxJson = new AjaxJson();
		ajaxJson.setMsg(msg);
		ajaxJson.setSuccess(false);
		return ajaxJson;
	}
	
	
	/**
	 * 返回成功
	 * @param msg
	 * @param body
	 * @return
	 */
	public static AjaxJson returnSucccess(String msg, Object body){
		AjaxJson ajaxJson = new AjaxJson();
		if(msg != null){
			ajaxJson.setMsg(msg);			
		}
		if(body != null){
			ajaxJson.setBody(body);
		}
		ajaxJson.setSuccess(true);
		return ajaxJson;
	}
	
	/**
	 * 返回成功
	 * @param body
	 * @return
	 */
	public static AjaxJson returnSucccess(Object body){
		return returnSucccess("", body);
	}
	
	/**
	 * 返回成功
	 * @param msg
	 * @return
	 */
	public static AjaxJson returnSucccess(String msg){
		return returnSucccess(msg, null);
	}
	
	/**
	 * 返回成功
	 * @return
	 */
	public static AjaxJson returnSucccess(){
		return returnSucccess(null);
	}

	public void setBody(Object body) {
		this.body = toMap(body);
		
	}

	public void put(String key, Object value){//向json中添加属性，在js中访问，请调用data.map.key
		body.put(key, value);
	}
	
	public void remove(String key){
		body.remove(key);
	}
	
	
	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {//向json中添加属性，在js中访问，请调用data.msg
		this.msg = msg;
	}


	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	
	/**
	 * 转出Map对象
	 * @param object
	 * @return
	 * @throws IllegalAccessException 
	 * @throws IllegalArgumentException 
	 */
	public LinkedHashMap<String, Object> toMap(Object object){
		LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
		Map<?, ?> objMap = new HashMap<Object, Object>();
		if(object instanceof Map){
			objMap = (Map<?, ?>)object;
			
		}
		else{
			if(!(object instanceof String)){
				try{
					Field[] declaredFields = object.getClass().getDeclaredFields();
					for (Field field : declaredFields) {
						field.setAccessible(true);
						map.put(field.getName(), field.get(object));
					}
				}
				catch(IllegalArgumentException  | IllegalAccessException ex){
					throw new IllegalArgumentException(ex);
				}
				
			}
			else{
				throw new IllegalArgumentException("参数类型错误");
			}
		}
		for(Map.Entry<?, ?> entity : objMap.entrySet()){
			map.put(String.valueOf(entity.getKey()), entity.getValue());
		}
		
		return map;
	}
	
	@JsonIgnore//返回对象时忽略此属性
	public String getJsonStr() {//返回json字符串数组，将访问msg和key的方式统一化，都使用data.key的方式直接访问。

		String json = JsonMapper.getInstance().toJson(this);
		return json;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return errorCode;
	}
}
