package com.crawler.waqf.modules.sys.dao;

import java.util.List;

import com.crawler.waqf.common.persistence.TreeDao;
import com.crawler.waqf.common.persistence.annotation.MyBatisDao;
import com.crawler.waqf.modules.sys.entity.Area;

/**
 * 区域DAO接口
 * 
 * @version 2014-05-16
 */
@MyBatisDao
public interface AreaDao extends TreeDao<Area> {

	/**
	 * 获取城市
	 * @param city
	 * @return
	 */
	Area findCity(String city);
	
	/**
	 * 获取省份
	 * @param province
	 * @return
	 */
	Area findProvince(String province);
	
	/**
	 * 获取所有所有城市列表
	 * @return
	 */
	List<Area> findAllCities();
	
}
